/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.scripts;

import com.suncode.plugin.rpa.scripts.ScriptsService;
import com.suncode.plugin.rpa.scripts.dto.CreateScriptDto;
import com.suncode.plugin.rpa.scripts.dto.UpdateScriptDto;
import com.suncode.plugin.rpa.scripts.entities.Script;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"scripts"})
public class ScriptsController {
    private final ScriptsService scriptsService;

    @Autowired
    public ScriptsController(ScriptsService scriptsService) {
        this.scriptsService = scriptsService;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Script> getScripts() {
        return this.scriptsService.getScripts();
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Script getScript(@PathVariable String id) {
        return this.scriptsService.getScript(id);
    }

    @RequestMapping(method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public Script createScript(@RequestBody CreateScriptDto createScriptDto) {
        return this.scriptsService.createScript(createScriptDto);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public Script updateScript(@PathVariable String id, @RequestBody UpdateScriptDto updateScriptDto) {
        return this.scriptsService.updateScript(id, updateScriptDto);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public Script deleteScript(@PathVariable String id) {
        return this.scriptsService.deleteScript(id);
    }
}

