/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.logs;

import com.suncode.plugin.rpa.logs.LogsService;
import com.suncode.plugin.rpa.logs.dto.LogResponseDto;
import com.suncode.plugin.rpa.logs.dto.LogWorkerMessageDto;
import com.suncode.pwfl.SystemVersion;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.MarkerFactory;
import org.springframework.stereotype.Service;

@Service
public class LogsServiceImpl
implements LogsService {
    private static final Logger log = LoggerFactory.getLogger(LogsServiceImpl.class);
    private static final int INITIAL_MAX_LINES = 200;
    private static final String PLUSWORKFLOW_HOME_KEY = "plusworkflow.home";

    @Override
    public void log(LogWorkerMessageDto logWorkerMessage) {
        MDC.put((String)"marker", (String)logWorkerMessage.getWorkerId());
        switch (logWorkerMessage.getType()) {
            case DEBUG: {
                log.debug(MarkerFactory.getMarker((String)logWorkerMessage.getWorkerId()), logWorkerMessage.getContent());
                break;
            }
            case ERROR: {
                log.error(MarkerFactory.getMarker((String)logWorkerMessage.getWorkerId()), logWorkerMessage.getContent());
                break;
            }
            case INFO: {
                log.info(MarkerFactory.getMarker((String)logWorkerMessage.getWorkerId()), logWorkerMessage.getContent());
                break;
            }
            case TRACE: {
                log.trace(MarkerFactory.getMarker((String)logWorkerMessage.getWorkerId()), logWorkerMessage.getContent());
                break;
            }
            case WARN: {
                log.warn(MarkerFactory.getMarker((String)logWorkerMessage.getWorkerId()), logWorkerMessage.getContent());
            }
        }
    }

    @Override
    public LogResponseDto getLog(String workerId) {
        List<String> workerLogs = this.getLogsByWorkerId(workerId).stream().map(line -> line.replace("<br />", System.lineSeparator())).collect(Collectors.toList());
        int size = workerLogs.size();
        int toLine = size - 1;
        return new LogResponseDto(this.getResponseLogs(workerLogs, Math.max(0, size - 200), size), Math.max(-1, toLine - 200), toLine);
    }

    @Override
    public LogResponseDto updatedLog(String workerId, int lastLine) {
        List<String> workerLogs = this.getLogsByWorkerId(workerId).stream().map(line -> line.replace("<br />", System.lineSeparator())).collect(Collectors.toList());
        int size = workerLogs.size();
        int fromLine = lastLine + 1;
        int toLine = size - 1;
        if (size <= fromLine) {
            return new LogResponseDto("", -1, -1);
        }
        return new LogResponseDto(this.getResponseLogs(workerLogs, fromLine, size), fromLine, toLine);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getLogsByWorkerId(String workerId) {
        Path logsPath = SystemVersion.getVersion().startsWith("4.1") ? Paths.get(System.getProperty(PLUSWORKFLOW_HOME_KEY), "logs", "rpa-manager", "rpa-manager.log") : Paths.get(System.getProperty(PLUSWORKFLOW_HOME_KEY), new String[0]).getParent().resolve(Paths.get("logs", "rpa-manager", "rpa-manager.log"));
        try (Stream<String> lines = Files.lines(logsPath);){
            List<String> list = lines.filter(line -> line.startsWith(workerId + " |")).collect(Collectors.toList());
            return list;
        }
    }

    private String getResponseLogs(List<String> workerLogs, int fromLine, int toLine) {
        List<String> truncatedWorkerLogs = workerLogs.subList(fromLine, toLine);
        List formattedWorkerLogs = truncatedWorkerLogs.stream().map(line -> line.split(" \\| ")[1]).collect(Collectors.toList());
        return String.join((CharSequence)"\n", formattedWorkerLogs);
    }
}

