/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.configs;

import com.suncode.plugin.rpa.configs.ConfigsDao;
import com.suncode.plugin.rpa.configs.ConfigsService;
import com.suncode.plugin.rpa.configs.dto.CreateConfigDto;
import com.suncode.plugin.rpa.configs.dto.UpdateConfigDto;
import com.suncode.plugin.rpa.configs.entities.Config;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfigsServiceImpl
implements ConfigsService {
    private final ConfigsDao configsDao;

    @Autowired
    public ConfigsServiceImpl(ConfigsDao configsDao) {
        this.configsDao = configsDao;
    }

    @Override
    @Transactional
    public List<Config> getConfigs() {
        List configs = this.configsDao.getAll(new String[0]);
        configs.sort(Comparator.comparing(Config::getId));
        return configs;
    }

    @Override
    @Transactional
    public Config getConfig(String id) {
        return (Config)this.configsDao.get((Serializable)((Object)id));
    }

    @Override
    @Transactional
    public Config createConfig(CreateConfigDto createConfigDto) {
        Config config = new Config();
        config.setId(createConfigDto.getId());
        config.setActivityDefId(createConfigDto.getActivityDefId());
        config.setAcceptUserName(createConfigDto.getAcceptUserName());
        config.setErrorActionName(createConfigDto.getErrorActionName());
        config.setProcessDefId(createConfigDto.getProcessDefId());
        config.setScriptId(createConfigDto.getScriptId());
        config.setSuccessActionName(createConfigDto.getSuccessActionName());
        config.setScreenshotDocClassId(createConfigDto.getScreenshotDocClassId());
        String id = (String)((Object)this.configsDao.save(config));
        return (Config)this.configsDao.get((Serializable)((Object)id));
    }

    @Override
    @Transactional
    public Config updateConfig(String id, UpdateConfigDto updateConfigDto) {
        Config config = (Config)this.configsDao.get((Serializable)((Object)id));
        config.setActivityDefId(updateConfigDto.getActivityDefId());
        config.setAcceptUserName(updateConfigDto.getAcceptUserName());
        config.setErrorActionName(updateConfigDto.getErrorActionName());
        config.setProcessDefId(updateConfigDto.getProcessDefId());
        config.setScriptId(updateConfigDto.getScriptId());
        config.setSuccessActionName(updateConfigDto.getSuccessActionName());
        config.setScreenshotDocClassId(updateConfigDto.getScreenshotDocClassId());
        this.configsDao.update(config);
        return config;
    }

    @Override
    @Transactional
    public Config deleteConfig(String id) {
        Config config = (Config)this.configsDao.get((Serializable)((Object)id));
        this.configsDao.delete(config);
        return config;
    }
}

