//String.endsWith polyfill for IE
String.prototype.endsWith || (String.prototype.endsWith = function (t, n) {
    return (void 0 === n || n > this.length) && (n = this.length), this.substring(n - t.length, n) === t
});
//uuid generator
!function (t, e) {
    "object" == typeof exports && "undefined" != typeof module ? module.exports = e() : "function" == typeof define && define.amd ? define(e) : (t = "undefined" != typeof globalThis ? globalThis : t || self).uuidv4 = e()
}(this, (function () {
    "use strict";
    var t, e = new Uint8Array(16);

    function o() {
        if (!t && !(t = "undefined" != typeof crypto && crypto.getRandomValues && crypto.getRandomValues.bind(crypto) || "undefined" != typeof msCrypto && "function" == typeof msCrypto.getRandomValues && msCrypto.getRandomValues.bind(msCrypto))) throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");
        return t(e)
    }

    var n = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;

    function r(t) {
        return "string" == typeof t && n.test(t)
    }

    for (var i = [], u = 0; u < 256; ++u) i.push((u + 256).toString(16).substr(1));
    return function (t, e, n) {
        var u = (t = t || {}).random || (t.rng || o)();
        if (u[6] = 15 & u[6] | 64, u[8] = 63 & u[8] | 128, e) {
            n = n || 0;
            for (var f = 0; f < 16; ++f) e[n + f] = u[f];
            return e
        }
        return function (t) {
            var e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 0,
                o = (i[t[e + 0]] + i[t[e + 1]] + i[t[e + 2]] + i[t[e + 3]] + "-" + i[t[e + 4]] + i[t[e + 5]] + "-" + i[t[e + 6]] + i[t[e + 7]] + "-" + i[t[e + 8]] + i[t[e + 9]] + "-" + i[t[e + 10]] + i[t[e + 11]] + i[t[e + 12]] + i[t[e + 13]] + i[t[e + 14]] + i[t[e + 15]]).toLowerCase();
            if (!r(o)) throw TypeError("Stringified UUID is invalid");
            return o
        }(u)
    }
}));

DSRPA = {t: PW.I18N.createT('com.suncode.plugin-rpa-datasources')}

PW.DataSources.register('rpaDatasource', {
    buildParams: function (form) {
        form.addField('initialUrl');
        form.addField('defaultTimeout');
        form.addCombobox({
            id: 'webDriverType',
            valueField: 'id',
            displayField: 'display',
            fields: [
                {name: 'id', type: 'string'},
                {name: 'display', type: 'string'}
            ],
            values: this.loadDriversList()
        });
        form.addField('driverArgs');
        form.form.add({
            xtype: 'fieldset',
            columnWidth: 0.5,
            title: DSRPA.t('rpaDatasource.options'),
            collapsed: true,
            collapsible: true,
            defaultType: 'checkboxfield',
            defaults: {anchor: '100%'},
            layout: 'anchor',
            items: [{
                id: 'exDirPath',
                boxLabel: DSRPA.t('rpaDatasource.addExecutionPath'),
                labelWidth: 300,
                name: 'executionDirPath',
                listeners: {
                    change: function (target, newValue) {
                        var outputParametersCmp = Ext4.getCmp('outputParameters');
                        if (newValue && executionDirPathParamExists(outputParametersCmp)) return;
                        if (newValue) {
                            var newRow;
                            if (outputParametersCmp.items.length == 2 && outputParametersCmp.items.getAt(1).asPlaceholder) {
                                newRow = outputParametersCmp.addRow(false);
                                outputParametersCmp.removeRow(1);
                            } else {
                                newRow = outputParametersCmp.addRow(false);
                            }
                            var idField = newRow.down('#outputParametersId');
                            idField.setValue('executionDirPath');
                            idField.disable();
                            newRow.down('#outputParametersName').setValue(DSRPA.t('rpaDatasource.executionPath'));
                            var typeField = newRow.down('#outputParametersType');
                            typeField.setValue('string');
                            typeField.disable();
                            newRow.items.getAt(1).items.getAt(1).disable();
                        } else {
                            var indexToRemove = -1;
                            for (var i = 1; i < outputParametersCmp.items.length; i++) {
                                if (outputParametersCmp.items.getAt(i).down('#outputParametersId').getValue() === 'executionDirPath') {
                                    indexToRemove = i;
                                    break;
                                }
                            }
                            if (indexToRemove == 1 && outputParametersCmp.items.length == 2) {
                                outputParametersCmp.addRow(true);
                            }
                            outputParametersCmp.removeRow(indexToRemove);
                        }
                    }
                }
            }, {
                id: 'showComments',
                boxLabel: DSRPA.t('rpaDatasource.showComments'),
                labelWidth: 300,
                name: 'showComments',
                listeners: {
                    change: function (target, newValue) {
                        if (newValue) {
                            this.showComments(form);
                        } else {
                            this.hideComments(form);
                        }
                    }.bind(this)
                }
            }, {
                xtype: 'fieldcontainer',
                layout: 'hbox',
                items: [{
                    xtype: 'filebutton',
                    text: DSRPA.t('rpaDatasource.importSide'),
                    listeners: {
                        afterrender: function (button) {
                            button.fileInputEl.set({accept: '.side'});
                        },
                        change: function (button) {
                            fileSelectionHandler(button, form);
                        }
                    }
                }, {
                    xtype: 'splitter'
                }, {
                    xtype: 'button',
                    text: DSRPA.t('rpaDatasource.exportSide'),
                    handler: function () {
                        exportSide(form);
                    }
                }]
            }]
        });
        var commandsTable = form.addTable({id: 'commands', name: DSRPA.t('rpaDatasource.commands')});
        commandsTable.addField({id: 'command_id', hidden: true});
        commandsTable.addCombobox({
            id: 'command',
            valueField: 'id',
            displayField: 'display',
            fields: [
                {name: 'id', type: 'string'},
                {name: 'display', type: 'string'}
            ],
            values: this.getCommands(),
            sort: [{
                property: 'display',
                direction: 'DESC'
            }]
        });
        commandsTable.addField('target');
        commandsTable.addField('value');
        commandsTable.addField('comment');
        var inputParameters = form.addTable({id: 'inputParameters', name: DSRPA.t('rpaDatasource.inputParameters')});
        inputParameters.addField('inputParametersId');
        inputParameters.addField('inputParametersName');
        inputParameters.addCombobox(this.getInputTypesComboboxValues('inputParametersType'));
        var outputParameters = form.addTable({id: 'outputParameters', name: DSRPA.t('rpaDatasource.outputParameters')});
        outputParameters.addField('outputParametersId');
        outputParameters.addField('outputParametersName');
        outputParameters.addCombobox(this.getOutputTypesComboboxValues('outputParametersType'));
        form.hide('command_id');
        window.setTimeout(function () {
            this.afterLoadFormHandler(form);
        }.bind(this), 100);
    },

    getInputTypesComboboxValues: function (id) {
        return {
            id: id,
            valueField: 'id',
            displayField: 'display',
            fields: [
                {name: 'id', type: 'string'},
                {name: 'display', type: 'string'}
            ],
            values: [{id: 'string', display: 'string'},
                {id: 'number', display: 'number'},
                {id: 'boolean', display: 'boolean'},
                {id: 'date', display: 'date'},
                {id: 'string[]', display: 'string[]'},
                {id: 'number[]', display: 'number[]'},
                {id: 'boolean[]', display: 'boolean[]'},
                {id: 'date[]', display: 'date[]'}]
        }
    },

    getOutputTypesComboboxValues: function (id) {
        return {
            id: id,
            valueField: 'id',
            displayField: 'display',
            fields: [
                {name: 'id', type: 'string'},
                {name: 'display', type: 'string'}
            ],
            values: [{id: 'string', display: 'string'},
                {id: 'integer', display: 'integer'},
                {id: 'float', display: 'float'},
                {id: 'boolean', display: 'boolean'},
                {id: 'date', display: 'date'},
                {id: 'datetime', display: 'datetime'}]
        }
    },

    afterLoadFormHandler: function (form) {
        this.hideComments(form);
        var commandsCmp = form.form.down('#commands');
        commandsCmp.down('removablefield').down('#command_id').on('enable', function () {
            this.setValue(uuidv4());
        });
        commandsCmp.onAdd = function (addedRow) {
            if (!Ext4.getCmp('showComments').getValue()) {
                addedRow.down('#comment').hide();
            }
            addedRow.down('#command_id').setValue(uuidv4()); //set value of hidden command_id
        }.bind(this);
        if (!form.getValue('defaultTimeout')) {
            form.form.down('#defaultTimeout').setValue(300); //set default value of timeout to 300
        }
        var outputParametersCmp = Ext4.getCmp('outputParameters');
        for (var i = 1; i < outputParametersCmp.items.length; i++) {
            var id = outputParametersCmp.items.getAt(i).down('#outputParametersId');
            if (id.getValue() === 'executionDirPath') {
                id.disable();
                outputParametersCmp.items.getAt(i).down('#outputParametersType').disable();
                outputParametersCmp.items.getAt(i).items.getAt(1).items.getAt(1).disable();
                Ext4.getCmp('exDirPath').setValue(true);
            }
        }
    },

    hideComments: function (form) {
        form.hide('comment');
        var commandsCmp = form.form.down('#commands');
        var commandItems = commandsCmp.items.items;
        for (var i = 1; i < commandItems.length; i++) {
            commandItems[i].down('#comment').hidden = true;
        }
        jQuery('table#commands > tbody > tr > td > div > div > div > div > div > div >'
            + ' table > tbody > tr > td > div > div > div > table:has(input[name="comment"])').hide();
        commandsCmp.updateLayout();
    },

    showComments: function (form) {
        form.show('comment');
        var commandsCmp = form.form.down('#commands');
        var commandItems = commandsCmp.items.items;
        for (var i = 1; i < commandItems.length; i++) {
            commandItems[i].down('#comment').hidden = false;
        }
        jQuery('table#commands > tbody > tr > td > div > div > div > div > div > div >'
            + ' table > tbody > tr > td > div > div > div > table:has(input[name="comment"])').show();
        commandsCmp.updateLayout();
    },

    seleniumIdeCommands: [{"id": "acceptAlert", "display": "accept alert"}, {
        "id": "acceptConfirmation",
        "display": "accept confirmation"
    }, {"id": "addSelection", "display": "add selection"}, {"id": "answerPrompt", "display": "answer prompt"}, {
        "id": "assert",
        "display": "assert"
    }, {"id": "assertAlert", "display": "assert alert"}, {"id": "assertChecked", "display": "assert checked"}, {
        "id": "assertConfirmation",
        "display": "assert confirmation"
    }, {"id": "assertEditable", "display": "assert editable"}, {
        "id": "assertElementPresent",
        "display": "assert element present"
    }, {"id": "assertElementNotPresent", "display": "assert element not present"}, {
        "id": "assertNotChecked",
        "display": "assert not checked"
    }, {"id": "assertNotEditable", "display": "assert not editable"}, {
        "id": "assertNotSelectedValue",
        "display": "assert not selected value"
    }, {"id": "assertNotText", "display": "assert not text"}, {"id": "assertPrompt", "display": "assert prompt"}, {
        "id": "assertSelectedValue",
        "display": "assert selected value"
    }, {"id": "assertSelectedLabel", "display": "assert selected label"}, {"id": "assertText", "display": "assert text"}, {
        "id": "assertTitle",
        "display": "assert title"
    }, {"id": "assertValue", "display": "assert value"}, {"id": "dismissConfirmation", "display": "dismiss confirmation"}, {
        "id": "dismissPrompt",
        "display": "dismiss prompt"
    }, {"id": "captureEntirePageScreenshot", "display": "capture entire page screenshot"}, {"id": "catch", "display": "catch"}, {
        "id": "check",
        "display": "check"
    }, {"id": "click", "display": "click"}, {"id": "clickAt", "display": "click at"}, {"id": "close", "display": "close"}, {
        "id": "debugger",
        "display": "debugger"
    }, {"id": "do", "display": "do"}, {"id": "doubleClick", "display": "double click"}, {
        "id": "doubleClickAt",
        "display": "double click at"
    }, {"id": "dragAndDropToObject", "display": "drag and drop to object"}, {"id": "echo", "display": "echo"}, {
        "id": "editContent",
        "display": "edit content"
    }, {"id": "else", "display": "else"}, {"id": "elseIf", "display": "else if"}, {"id": "end", "display": "end"}, {
        "id": "endCatch",
        "display": "end catch"
    }, {"id": "executeScript", "display": "execute script"}, {"id": "executeAsyncScript", "display": "execute async script"}, {
        "id": "forEach",
        "display": "for each"
    }, {"id": "if", "display": "if"}, {"id": "mouseDown", "display": "mouse down"}, {
        "id": "mouseDownAt",
        "display": "mouse down at"
    }, {"id": "mouseMoveAt", "display": "mouse move at"}, {"id": "mouseOut", "display": "mouse out"}, {
        "id": "mouseOver",
        "display": "mouse over"
    }, {"id": "mouseUp", "display": "mouse up"}, {"id": "mouseUpAt", "display": "mouse up at"}, {"id": "open", "display": "open"}, {
        "id": "pause",
        "display": "pause"
    }, {"id": "removeSelection", "display": "remove selection"}, {"id": "repeatIf", "display": "repeat if"}, {
        "id": "run",
        "display": "run"
    }, {"id": "runScript", "display": "run script"}, {"id": "select", "display": "select"}, {
        "id": "selectFrame",
        "display": "select frame"
    }, {"id": "selectWindow", "display": "select window"}, {"id": "sendKeys", "display": "send keys"}, {
        "id": "setSpeed",
        "display": "set speed"
    }, {"id": "setWindowSize", "display": "set window size"}, {"id": "store", "display": "store"}, {
        "id": "storeAttribute",
        "display": "store attribute"
    }, {"id": "storeXpathCount", "display": "store xpath count"}, {"id": "storeJson", "display": "store json"}, {
        "id": "storeText",
        "display": "store text"
    }, {"id": "storeTitle", "display": "store title"}, {"id": "storeValue", "display": "store value"}, {
        "id": "storeWindowHandle",
        "display": "store window handle"
    }, {"id": "times", "display": "times"}, {"id": "try", "display": "try"}, {"id": "type", "display": "type"}, {
        "id": "uncheck",
        "display": "uncheck"
    }, {"id": "verify", "display": "verify"}, {"id": "verifyChecked", "display": "verify checked"}, {
        "id": "verifyEditable",
        "display": "verify editable"
    }, {"id": "verifyElementPresent", "display": "verify element present"}, {
        "id": "verifyElementNotPresent",
        "display": "verify element not present"
    }, {"id": "verifyNotChecked", "display": "verify not checked"}, {
        "id": "verifyNotEditable",
        "display": "verify not editable"
    }, {"id": "verifyNotSelectedValue", "display": "verify not selected value"}, {
        "id": "verifyNotText",
        "display": "verify not text"
    }, {"id": "verifySelectedLabel", "display": "verify selected label"}, {
        "id": "verifySelectedValue",
        "display": "verify selected value"
    }, {"id": "verifyText", "display": "verify text"}, {"id": "verifyTitle", "display": "verify title"}, {
        "id": "verifyValue",
        "display": "verify value"
    }, {"id": "waitForElementEditable", "display": "wait for element editable"}, {
        "id": "waitForElementNotEditable",
        "display": "wait for element not editable"
    }, {"id": "waitForElementNotPresent", "display": "wait for element not present"}, {
        "id": "waitForElementNotVisible",
        "display": "wait for element not visible"
    }, {"id": "waitForElementPresent", "display": "wait for element present"}, {
        "id": "waitForElementVisible",
        "display": "wait for element visible"
    }, {"id": "while", "display": "while"}],
    getCommands: function () {
        return this.seleniumIdeCommands;
    },
    loadDriversList: function () {
        let result = {};
        jQuery.ajax({
            url: PW.getAbsolutePath("/plugin/com.suncode.plugin-rpa-datasources/driver/list"),
            method: 'GET',
            async: false,
            success: function(response) {
                result = response.data;
            },
            error: function(xhr, status, error) {
                console.error('Error downloading driver list:', error);
            }
        });
        return result;
    }
});

function fileSelectionHandler(button, form) {
    var fileInput = button.fileInputEl.dom;
    var reader = new FileReader();
    reader.onload = function (event) {
        fileLoadHandler(event.target.result, form, fileInput);
    };
    var file = fileInput.files[0];
    if (file.type === '' && file.name.endsWith('.side')) {
        reader.readAsText(file);
    } else {
        PW.ui.Message.error(DSRPA.t('rpaDatasource.loadSideError'));
    }
}

function fileLoadHandler(result, form, fileInput) {
    form.mask();
    var commandsCmp = Ext4.getCmp('commands');
    var initialCommandsLength = commandsCmp.items.length - 1;
    var parsedResult = JSON.parse(result);
    form.form.down('#initialUrl').setValue(parsedResult.url);
    form.form.down('#defaultTimeout').setValue(parsedResult.suites[0].timeout);
    var commands = parsedResult.tests.shift().commands;
    var promises = [];
    commands.forEach(function (command) {
        var def = jQuery.Deferred();
        setTimeout(function () {
            addCommandRow(commandsCmp, command);
            def.resolve();
        }, 1);
        promises.push(def.promise());
    });
    jQuery.when.apply(jQuery, promises).then(function () {
        for (var i = 0; i < initialCommandsLength; i++) {
            commandsCmp.removeRow(1);
        }
        form.unmask();
        fileInput.clear();
        PW.ui.Message.success(DSRPA.t('rpaDatasource.loadSideSuccess'));
    }).fail(function () {
        form.unmask();
        PW.ui.Message.error(DSRPA.t('rpaDatasource.loadSideError'));
    });
}

function addCommandRow(commandsCmp, command) {
    var newRow = commandsCmp.addRow(false);
    newRow.down('#command_id').setValue(command.id);
    newRow.down('#command').setValue(command.command);
    newRow.down('#target').setValue(command.target);
    newRow.down('#value').setValue(command.value);
    newRow.down('#comment').setValue(command.comment);
}

function exportSide(form) {
    var name = (form.configurationPanel.down('[name=id]').getValue() || 'default');
    var url = form.form.down('#initialUrl').getValue();
    var testId = uuidv4();
    var side = {
        id: uuidv4(),
        version: '2.0',
        name: name,
        url: url,
        tests: [],
        suites: [{
            id: uuidv4(),
            name: 'Default Suite',
            persistSession: false,
            parallel: false,
            timeout: form.form.down('#defaultTimeout').getValue(),
            tests: [testId]
        }],
        urls: [url],
        plugins: []
    };
    var test = {
        id: testId,
        name: 'Untitled',
        commands: []
    };
    var commandsArray = form.form.down('#commands').items.items.filter(function (item) {
        return item.xtype === 'removablefield';
    });
    commandsArray.forEach(function (commandEl) {
        var command = {
            id: uuidv4(),
            comment: commandEl.down('#comment').getValue(),
            command: commandEl.down('#command').getValue(),
            target: commandEl.down('#target').getValue(),
            targets: [],
            value: commandEl.down('#value').getValue()
        };
        test.commands.push(command);
    });
    side.tests.push(test);
    var blob = new Blob([JSON.stringify(side)], {type: 'application/octet-stream'});
    var filename = name + '.side';
    if (window.navigator && window.navigator.msSaveOrOpenBlob) {
        window.navigator.msSaveOrOpenBlob(blob, filename);
    } else {
        var url = URL.createObjectURL(blob);
        var link = document.createElement('a');
        link.href = url;
        link.setAttribute('download', filename);
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
        URL.revokeObjectURL(link.href);
    }
}

function executionDirPathParamExists(outputParametersCmp) {
    var exists = false;
    for (var i = 1; i < outputParametersCmp.items.length; i++) {
        if (outputParametersCmp.items.getAt(i).down('#outputParametersId').getValue() === 'executionDirPath') {
            exists = true;
            break;
        }
    }
    return exists;
}
