/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.type;

import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public enum OutputTypes {
    STRING("string"),
    INTEGER("integer"),
    FLOAT("float"),
    BOOLEAN("boolean"),
    DATE("date"),
    DATETIME("datetime");

    public final String type;
    private static final DateTimeFormatter DATE_FORMATTER;
    private static final DateTimeFormatter DATETIME_FORMATTER;

    private OutputTypes(String type) {
        this.type = type;
    }

    public static OutputTypes typeOf(String type) {
        for (OutputTypes outputType : OutputTypes.values()) {
            if (!outputType.getType().equals(type)) continue;
            return outputType;
        }
        throw new IllegalArgumentException("No output type '" + type + "' exist!");
    }

    public static Object resolve(String value, OutputTypes type) {
        switch (type) {
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case DATE: {
                return LocalDate.parse((String)value, (DateTimeFormatter)DATE_FORMATTER);
            }
            case DATETIME: {
                return LocalDateTime.parse((String)value, (DateTimeFormatter)DATETIME_FORMATTER);
            }
            case FLOAT: {
                return Double.parseDouble(value);
            }
            case INTEGER: {
                return Long.parseLong(value);
            }
            case STRING: {
                return value;
            }
        }
        throw new IllegalArgumentException("Output parameter has illegal type: '" + String.valueOf((Object)type) + "'!");
    }

    public String getType() {
        return this.type;
    }

    static {
        DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    }
}

