/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.type;

import com.suncode.plugin.datasource.rpa.util.LambdaExceptionUtil;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public enum InputTypes {
    STRING("string"),
    NUMBER("number"),
    BOOLEAN("boolean"),
    DATE("date"),
    STRING_ARRAY("string[]"),
    NUMBER_ARRAY("number[]"),
    BOOLEAN_ARRAY("boolean[]"),
    DATE_ARRAY("date[]");

    public final String type;

    private InputTypes(String type) {
        this.type = type;
    }

    public static InputTypes typeOf(String type) {
        for (InputTypes inputType : InputTypes.values()) {
            if (!inputType.getType().equals(type)) continue;
            return inputType;
        }
        throw new IllegalArgumentException("No input type '" + type + "' exist!");
    }

    public static Object resolve(String value, InputTypes type) throws ParseException {
        switch (type) {
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case DATE: {
                return LocalDateTime.parse((String)value).toLocalDate();
            }
            case NUMBER: {
                return NumberFormat.getInstance().parse(value);
            }
            case STRING: {
                return value;
            }
            case BOOLEAN_ARRAY: {
                return InputTypes.handleBooleanArray(value.split(";", -1));
            }
            case DATE_ARRAY: {
                return InputTypes.handleDateArray(value.split(";", -1));
            }
            case NUMBER_ARRAY: {
                return InputTypes.handleNumberArray(value.split(";", -1));
            }
            case STRING_ARRAY: {
                return Arrays.asList(value.split(";", -1));
            }
        }
        throw new IllegalArgumentException("Input parameter has illegal type: '" + String.valueOf((Object)type) + "'!");
    }

    private static List<Boolean> handleBooleanArray(String[] splittedBoolArray) {
        return Arrays.stream(splittedBoolArray).map(Boolean::parseBoolean).collect(Collectors.toList());
    }

    private static List<LocalDate> handleDateArray(String[] splittedDateArray) {
        return Arrays.stream(splittedDateArray).map(dateValueAsString -> LocalDateTime.parse((String)dateValueAsString).toLocalDate()).collect(Collectors.toList());
    }

    private static List<Number> handleNumberArray(String[] splittedNumberArray) throws ParseException {
        return Arrays.stream(splittedNumberArray).map(LambdaExceptionUtil.rethrowFunction(numberValueAsString -> NumberFormat.getInstance().parse((String)numberValueAsString))).collect(Collectors.toList());
    }

    public String getType() {
        return this.type;
    }
}

