/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.transform;

import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResultTransformer {
    private ResultTransformer() {
    }

    public static CountedResult<Map<String, Object>> transform(CountedResult<Map<String, Object>> executionResult, Map<String, String> filters, Pagination pagination) {
        if (filters != null) {
            ResultTransformer.applyFilters(executionResult.getData(), filters);
        }
        if (pagination != null) {
            ResultTransformer.applyPagination(executionResult, pagination);
        }
        return executionResult;
    }

    private static void applyFilters(List<Map<String, Object>> data, Map<String, String> filters) {
        filters.forEach((key, value) -> data.removeIf(map -> !Objects.toString(map.get(key), "").toUpperCase().contains(value.toUpperCase())));
    }

    private static void applyPagination(CountedResult<Map<String, Object>> result, Pagination pagination) {
        ResultTransformer.applySort(result.getData(), pagination.getSorter());
        List paginatedResultList = result.getData().subList(pagination.getStart(), Math.min(pagination.getStart() + pagination.getLimit(), result.getData().size()));
        result.setData(paginatedResultList);
    }

    private static void applySort(List<Map<String, Object>> data, Sorter sorter) {
        data.sort(Comparator.comparing(map -> Objects.toString(map.get(sorter.getProperty()), "").toUpperCase()));
        if (sorter.getDirection() == SortDirection.DESC) {
            Collections.reverse(data);
        }
    }
}

