/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.runner;

import com.suncode.plugin.datasource.rpa.type.InputTypes;
import com.suncode.plugin.datasource.rpa.util.LambdaExceptionUtil;
import com.suncode.pwfl.datasource.DataSourceParameter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jp.vmi.selenium.selenese.Runner;
import jp.vmi.selenium.selenese.VarsMap;
import lombok.NonNull;
import org.openqa.selenium.WebDriver;

public class RunnerBuilder {
    private WebDriver driver;
    private String executionDirPath;
    private VarsMap varsMap;
    private PrintStream outputPrintStream;

    public RunnerBuilder setDriver(@NonNull WebDriver driver) {
        if (driver == null) {
            throw new NullPointerException("driver is marked non-null but is null");
        }
        this.driver = driver;
        return this;
    }

    public RunnerBuilder setExecutionDirPath(@NonNull String executionDirPath) {
        if (executionDirPath == null) {
            throw new NullPointerException("executionDirPath is marked non-null but is null");
        }
        this.executionDirPath = executionDirPath;
        return this;
    }

    public RunnerBuilder populateVarsMap(@NonNull Set<DataSourceParameter> inputParameters, @NonNull Map<String, String> parameters) {
        if (inputParameters == null) {
            throw new NullPointerException("inputParameters is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.varsMap = inputParameters.stream().collect(Collectors.toMap(DataSourceParameter::getId, LambdaExceptionUtil.rethrowFunction(parameter -> InputTypes.resolve((String)parameters.get(parameter.getId()), InputTypes.typeOf(parameter.getType()))), (existingValue, newValue) -> newValue, VarsMap::new));
        return this;
    }

    public RunnerBuilder setOutputStream(@NonNull ByteArrayOutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        this.outputPrintStream = new PrintStream(outputStream);
        return this;
    }

    public Runner build() {
        if (this.driver == null) {
            throw new IllegalStateException("WebDriver must be provided!");
        }
        Runner runner = new Runner();
        runner.setDriver(this.driver);
        if (this.executionDirPath != null) {
            this.provideExecutionPath(runner);
        }
        runner.setVarsMap(this.varsMap);
        runner.setPrintStream(this.outputPrintStream);
        return runner;
    }

    private void provideExecutionPath(Runner runner) {
        runner.setScreenshotDir(this.executionDirPath);
        runner.setScreenshotOnFailDir(this.executionDirPath);
        runner.setJUnitResultDir(this.executionDirPath);
        runner.setHtmlResultDir(this.executionDirPath);
    }
}

