/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.component;

import com.suncode.plugin.datasource.rpa.collection.RpaCommand;
import com.suncode.plugin.datasource.rpa.driver.WebDriverType;
import com.suncode.plugin.datasource.rpa.execution.Execution;
import com.suncode.plugin.datasource.rpa.execution.ExecutionParameters;
import com.suncode.plugin.datasource.rpa.execution.ExecutionResult;
import com.suncode.plugin.datasource.rpa.execution.ExecutionSemaphoreHolder;
import com.suncode.plugin.datasource.rpa.transform.ResultTransformer;
import com.suncode.plugin.datasource.rpa.util.RpaUtil;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.datasource.AbstractDataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpaDataSource
extends AbstractDataSourceInstance {
    private static final Logger log = LoggerFactory.getLogger(RpaDataSource.class);
    private final ExecutionSemaphoreHolder executionSemaphoreHolder;
    private final List<RpaCommand> commands;
    private final int defaultTimeout;
    private final String[] driverArgs;
    private final String initialUrl;
    private final Set<DataSourceParameter> inputParameters;
    private final Set<DataSourceParameter> outputParameters;
    private final WebDriverType webDriverType;

    public RpaDataSource(Parameters parameters, ExecutionSemaphoreHolder executionSemaphoreHolder) {
        this.executionSemaphoreHolder = executionSemaphoreHolder;
        this.commands = RpaUtil.buildCommands((String[])parameters.get("command_id", String[].class), (String[])parameters.get("command", String[].class), (String[])parameters.get("comment", String[].class), (String[])parameters.get("target", String[].class), (String[])parameters.get("value", String[].class));
        this.defaultTimeout = (Integer)parameters.get("defaultTimeout", Integer.TYPE);
        this.driverArgs = (String[])parameters.get("driverArgs", String[].class);
        this.initialUrl = (String)parameters.get("initialUrl", String.class);
        this.inputParameters = RpaUtil.buildParameters((String[])parameters.get("inputParametersId", String[].class), (String[])parameters.get("inputParametersName", String[].class), (String[])parameters.get("inputParametersType", String[].class));
        this.outputParameters = RpaUtil.buildParameters((String[])parameters.get("outputParametersId", String[].class), (String[])parameters.get("outputParametersName", String[].class), (String[])parameters.get("outputParametersType", String[].class));
        this.webDriverType = WebDriverType.valueOf((String)parameters.get("webDriverType"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountedResult<Map<String, Object>> execute(Map<String, String> parameters, Map<String, String> filters, Pagination pagination) {
        ExecutionResult execution;
        log.debug("Executing '" + this.getDataSourceId() + "' datasource...");
        ExecutionParameters executionParameters = this.getExecutionParameters(parameters);
        this.executionSemaphoreHolder.getSemaphore().acquire();
        try {
            execution = new Execution().perform(executionParameters, this.webDriverType);
        }
        finally {
            this.executionSemaphoreHolder.getSemaphore().release();
        }
        log.debug("Execution directory: " + execution.getExecutionDirPath());
        CountedResult<Map<String, Object>> executionCountedResult = filters == null && pagination == null ? execution.getCountedResult() : ResultTransformer.transform(execution.getCountedResult(), filters, pagination);
        log.debug("'" + this.getDataSourceId() + "' datasource execution finished!");
        return executionCountedResult;
    }

    private ExecutionParameters getExecutionParameters(Map<String, String> values) {
        return ExecutionParameters.builder().commands(this.commands).dataSourceId(this.getDataSourceId()).defaultTimeout(this.defaultTimeout).driverArgs(this.driverArgs).initialUrl(this.initialUrl).inputParameters(this.inputParameters).outputParameters(this.outputParameters).values(values).webDriverType(this.webDriverType).build();
    }

    public Set<DataSourceParameter> getInputParameters() {
        return this.inputParameters;
    }

    public Set<DataSourceParameter> getOutputParameters() {
        return this.outputParameters;
    }
}

