/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.execution;

import com.suncode.plugin.datasource.rpa.configuration.RpaConfigurationService;
import java.util.concurrent.Semaphore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecutionSemaphoreHolder {
    private final RpaConfigurationService rpaConfigurationService;
    private Semaphore semaphore;

    @Autowired
    public ExecutionSemaphoreHolder(RpaConfigurationService rpaConfigurationService) {
        this.rpaConfigurationService = rpaConfigurationService;
    }

    public void reconfigure(int permitsCount) {
        this.semaphore = new Semaphore(permitsCount);
    }

    public Semaphore getSemaphore() {
        this.ensureSemaphoreExist();
        return this.semaphore;
    }

    private void ensureSemaphoreExist() {
        if (this.semaphore == null) {
            this.semaphore = new Semaphore(this.rpaConfigurationService.getConfiguration().getSimultaneousInstances());
        }
    }
}

