/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.driver;

import java.nio.file.Paths;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;

public final class WebDriverProvider {
    private static final String HOME_DIRECTORY = "plusworkflow.home";
    public static final String CHROME_DRIVER_DIRECTORY_NAME = "chromeDriver";
    private static final String CHROME_DRIVER_LINUX = "chromedriver";
    private static final String CHROME_DRIVER_WINDOWS = "chromedriver.exe";
    public static final String EDGE_DRIVER_DIRECTORY_NAME = "edgeDriver";
    private static final String EDGE_DRIVER_LINUX = "msedgedriver";
    private static final String EDGE_DRIVER_WINDOWS = "msedgedriver.exe";

    private WebDriverProvider() {
    }

    public static WebDriver getChromeWebDriver() {
        String os = System.getProperty("os.name").toLowerCase();
        String driverPath = Paths.get(System.getProperty(HOME_DIRECTORY), CHROME_DRIVER_DIRECTORY_NAME, os.contains("win") ? CHROME_DRIVER_WINDOWS : CHROME_DRIVER_LINUX).toAbsolutePath().toString();
        System.setProperty("webdriver.chrome.driver", driverPath);
        return new ChromeDriver();
    }

    public static WebDriver getEdgeWebDriver() {
        String os = System.getProperty("os.name").toLowerCase();
        String driverPath = Paths.get(System.getProperty(HOME_DIRECTORY), EDGE_DRIVER_DIRECTORY_NAME, os.contains("win") ? EDGE_DRIVER_WINDOWS : EDGE_DRIVER_LINUX).toAbsolutePath().toString();
        System.setProperty("webdriver.edge.driver", driverPath);
        return new EdgeDriver();
    }
}

