/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.execution;

import com.suncode.plugin.datasource.rpa.driver.WebDriverProvider;
import com.suncode.plugin.datasource.rpa.driver.WebDriverType;
import com.suncode.plugin.datasource.rpa.execution.ExecutionParameters;
import com.suncode.plugin.datasource.rpa.execution.ExecutionResult;
import com.suncode.plugin.datasource.rpa.runner.RunnerBuilder;
import com.suncode.plugin.datasource.rpa.side.SideFilePathAndType;
import com.suncode.plugin.datasource.rpa.side.SideFileType;
import com.suncode.plugin.datasource.rpa.type.OutputTypes;
import com.suncode.plugin.datasource.rpa.util.CollectorsUtil;
import com.suncode.plugin.datasource.rpa.util.LambdaExceptionUtil;
import com.suncode.plugin.datasource.rpa.util.RpaUtil;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.search.CountedResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jp.vmi.selenium.selenese.Runner;
import jp.vmi.selenium.selenese.VarsMap;
import jp.vmi.selenium.selenese.result.Result;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Execution {
    private static final Logger log = LoggerFactory.getLogger(Execution.class);

    public ExecutionResult perform(ExecutionParameters key, WebDriverType webDriverType) throws IOException {
        WebDriver driver = webDriverType == WebDriverType.EDGE ? WebDriverProvider.getEdgeWebDriver() : WebDriverProvider.getChromeWebDriver();
        try {
            ExecutionResult executionResult;
            String executionDirPath = RpaUtil.getExecutionDirPath(key.getDataSourceId());
            List<SideFilePathAndType> sideFiles = RpaUtil.createSideFiles(key, executionDirPath);
            RpaUtil.writeParametersValuesToFile(executionDirPath, key.getValues());
            try (ByteArrayOutputStream driverConsoleOutputStream = new ByteArrayOutputStream();){
                VarsMap executionResultsMap = this.run(key, executionDirPath, driverConsoleOutputStream, driver, sideFiles);
                this.logExecutionOutput(driverConsoleOutputStream);
                executionResult = this.getExecutionResult(executionResultsMap, key.getOutputParameters(), executionDirPath);
            }
            return executionResult;
        }
        finally {
            driver.quit();
        }
    }

    private VarsMap run(ExecutionParameters key, String executionDirPath, ByteArrayOutputStream driverConsoleOutputStream, WebDriver driver, List<SideFilePathAndType> sideFiles) {
        Runner runner = new RunnerBuilder().populateVarsMap(key.getInputParameters(), key.getValues()).setExecutionDirPath(executionDirPath).setOutputStream(driverConsoleOutputStream).setDriver(driver).build();
        for (int index = 0; index < sideFiles.size(); ++index) {
            if (sideFiles.get(index).getSideFileType().equals((Object)SideFileType.TRY_BLOCK)) {
                Result result = runner.run(new String[]{sideFiles.get(index).getFilePath()});
                ++index;
                if (!result.isFailed()) continue;
                runner.run(new String[]{sideFiles.get(index).getFilePath()});
                continue;
            }
            runner.run(new String[]{sideFiles.get(index).getFilePath()});
        }
        return runner.getVarsMap();
    }

    private ExecutionResult getExecutionResult(VarsMap executionResultsMap, Set<DataSourceParameter> outputParameters, String executionDirPath) throws IOException {
        CountedResult<Map<String, Object>> countedResult = this.getCountedResult(this.mapResultsToOutputParameters(executionResultsMap, outputParameters));
        RpaUtil.addExecutionDirPathToResultList(countedResult, executionDirPath);
        RpaUtil.mergeScreensIntoPdf(executionDirPath);
        RpaUtil.zipExecutionFiles(executionDirPath);
        return new ExecutionResult(executionDirPath, countedResult);
    }

    private CountedResult<Map<String, Object>> getCountedResult(Map<DataSourceParameter, List<String>> resultsMap) {
        OptionalInt maxLengthOpt = resultsMap.values().stream().mapToInt(List::size).max();
        int maxLength = maxLengthOpt.isPresent() ? maxLengthOpt.getAsInt() : 0;
        List resultsList = IntStream.range(0, maxLength).boxed().map(LambdaExceptionUtil.rethrowFunction(i -> this.getResultsMap(resultsMap, (int)i))).collect(Collectors.toList());
        return new CountedResult((long)resultsList.size(), resultsList);
    }

    private Map<DataSourceParameter, List<String>> mapResultsToOutputParameters(VarsMap varsMap, Set<DataSourceParameter> outputParameters) {
        return outputParameters.stream().collect(Collectors.toMap(parameter -> parameter, parameter -> {
            Object outputParameterValue = varsMap.get((Object)parameter.getId());
            if (outputParameterValue == null) {
                return Collections.singletonList(OutputTypes.typeOf(parameter.getType()) == OutputTypes.STRING ? "" : null);
            }
            if (outputParameterValue instanceof Collection) {
                List outputParameterValuesList = (List)outputParameterValue;
                return outputParameterValuesList.stream().map(value -> Objects.toString(value, "")).collect(Collectors.toList());
            }
            return Collections.singletonList(outputParameterValue.toString());
        }, (existingValue, newValue) -> newValue, LinkedHashMap::new));
    }

    private Map<String, Object> getResultsMap(Map<DataSourceParameter, List<String>> resultsMap, int i) {
        return resultsMap.entrySet().stream().collect(CollectorsUtil.toMap(result -> ((DataSourceParameter)result.getKey()).getId(), LambdaExceptionUtil.rethrowFunction(result -> this.resolveValue((Map.Entry<DataSourceParameter, List<String>>)result, i))));
    }

    private Object resolveValue(Map.Entry<DataSourceParameter, List<String>> result, int i) {
        List<String> parameterResults = result.getValue();
        if (parameterResults.size() > i) {
            return OutputTypes.resolve(parameterResults.get(i), OutputTypes.typeOf(result.getKey().getType()));
        }
        return OutputTypes.typeOf(result.getKey().getType()) == OutputTypes.STRING ? "" : null;
    }

    private void logExecutionOutput(ByteArrayOutputStream driverConsoleOutputStream) throws IOException {
        log.debug(driverConsoleOutputStream.toString());
        driverConsoleOutputStream.close();
    }
}

