/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.suncode.plugin.datasource.rpa.collection.RpaCommand;
import com.suncode.plugin.datasource.rpa.execution.ExecutionParameters;
import com.suncode.plugin.datasource.rpa.side.Side;
import com.suncode.plugin.datasource.rpa.side.SideFilePathAndType;
import com.suncode.plugin.datasource.rpa.side.SideFileType;
import com.suncode.plugin.datasource.rpa.util.LambdaExceptionUtil;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.search.CountedResult;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.joda.time.LocalDateTime;
import org.springframework.util.Assert;

public class RpaUtil {
    private RpaUtil() {
    }

    public static List<RpaCommand> buildCommands(String[] ids, String[] commands, String[] comments, String[] targets, String[] values) {
        Assert.isTrue((ids.length == commands.length && ids.length == comments.length && ids.length == targets.length && ids.length == values.length ? 1 : 0) != 0, (String)"Commands lists length mismatch!");
        return IntStream.range(0, ids.length).mapToObj(i -> new RpaCommand(ids[i], commands[i], comments[i], targets[i], values[i])).collect(Collectors.toList());
    }

    public static Set<DataSourceParameter> buildParameters(String[] ids, String[] names, String[] types) {
        Assert.isTrue((ids.length == names.length && ids.length == types.length ? 1 : 0) != 0, (String)"Parameters lists length mismatch!");
        return IntStream.range(0, ids.length).mapToObj(i -> new DataSourceParameter(ids[i], names[i], types[i])).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static String getExecutionDirPath(String id) {
        Path rpaExecutionsDirPath = Paths.get(System.getProperty("plusworkflow.home"), "rpa-executions");
        File rpaExecutionsDir = rpaExecutionsDirPath.toFile();
        if (!rpaExecutionsDir.exists()) {
            rpaExecutionsDir.mkdirs();
        }
        Path executionDirPath = Paths.get(rpaExecutionsDirPath.toString(), id + "_" + LocalDateTime.now().toString("yyyyMMddHHmmssSSS"));
        executionDirPath.toFile().mkdir();
        return executionDirPath.toString();
    }

    public static List<SideFilePathAndType> createSideFiles(ExecutionParameters key, String executionDirPath) throws IOException {
        String sideTestsId = UUID.randomUUID().toString();
        LinkedList<SideFilePathAndType> sideFiles = new LinkedList<SideFilePathAndType>();
        Map<List<RpaCommand>, SideFileType> rpaCommands = RpaUtil.divideCommandsBasedOnTryCatchOccurrences(key.getCommands());
        Iterator<Map.Entry<List<RpaCommand>, SideFileType>> iterator = rpaCommands.entrySet().iterator();
        int fileNumber = 0;
        while (iterator.hasNext()) {
            Map.Entry<List<RpaCommand>, SideFileType> entry = iterator.next();
            String filePath = Paths.get(executionDirPath, key.getDataSourceId() + "_" + ++fileNumber + ".side").toString();
            SideFilePathAndType sideFile = SideFilePathAndType.builder().filePath(filePath).sideFileType(entry.getValue()).build();
            sideFiles.add(sideFile);
            RpaUtil.writeSideToFile(sideTestsId, filePath, key, entry.getKey());
        }
        return sideFiles;
    }

    public static void mergeScreensIntoPdf(String executionDirPath) throws IOException {
        File[] files = RpaUtil.getFilesByPattern(executionDirPath, "*.png");
        if (files.length <= 0) {
            return;
        }
        try (PDDocument doc = new PDDocument();){
            Comparator<File> byLastModified = Comparator.comparingLong(File::lastModified);
            Arrays.stream(files).sorted(byLastModified).forEach(LambdaExceptionUtil.rethrowConsumer(file -> {
                BufferedImage image = ImageIO.read(file);
                PDRectangle rectangle = new PDRectangle((float)image.getWidth(), (float)image.getHeight());
                PDPage page = new PDPage(rectangle);
                doc.addPage(page);
                PDImageXObject ximage = LosslessFactory.createFromImage((PDDocument)doc, (BufferedImage)image);
                try (PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true);){
                    contentStream.drawImage(ximage, 0.0f, 0.0f);
                }
            }));
            doc.save(Paths.get(executionDirPath, "screens.pdf").toString());
        }
    }

    public static void writeSideToFile(String testsId, String filename, ExecutionParameters key, List<RpaCommand> commands) throws IOException {
        Side side = new Side(key.getDataSourceId(), key.getInitialUrl(), testsId, commands, key.getDefaultTimeout());
        String sideAsJsonString = new GsonBuilder().setPrettyPrinting().create().toJson((Object)side);
        RpaUtil.writeStringToFile(filename, sideAsJsonString);
    }

    public static void writeParametersValuesToFile(String executionDirPath, Map<String, String> values) throws IOException {
        Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
        Map<String, String> copyOfValues = RpaUtil.deepCopyMap(gson, values);
        copyOfValues.forEach((key, value) -> {
            if (key.contains("password")) {
                copyOfValues.replace((String)key, StringUtils.repeat((String)"*", (int)value.length()));
            }
        });
        RpaUtil.writeStringToFile(Paths.get(executionDirPath, "parameters.json").toString(), gson.toJson(copyOfValues));
    }

    private static Map<String, String> deepCopyMap(Gson gson, Map<String, String> map) {
        String mapCopyAsString = gson.toJson(map);
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)gson.fromJson(mapCopyAsString, type);
    }

    public static void writeStringToFile(String filename, String content) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filename));){
            writer.write(content);
        }
    }

    public static void zipExecutionFiles(String executionDirPath) throws IOException {
        File[] files = RpaUtil.getFilesByPattern(executionDirPath, "*");
        try (FileOutputStream fileOutputStream = new FileOutputStream(Paths.get(executionDirPath, "execution.zip").toString());
             ZipOutputStream zipOut = new ZipOutputStream(fileOutputStream);){
            Arrays.stream(files).forEach(LambdaExceptionUtil.rethrowConsumer(file -> {
                try (FileInputStream fileInputStream = new FileInputStream((File)file);){
                    int length;
                    ZipEntry zipEntry = new ZipEntry(file.getName());
                    zipOut.putNextEntry(zipEntry);
                    byte[] bytes = new byte[1024];
                    while ((length = fileInputStream.read(bytes)) >= 0) {
                        zipOut.write(bytes, 0, length);
                    }
                }
            }));
        }
    }

    private static File[] getFilesByPattern(String path, String pattern) {
        File dir = new File(path);
        WildcardFileFilter fileFilter = new WildcardFileFilter(pattern);
        return dir.listFiles((FileFilter)fileFilter);
    }

    public static void addExecutionDirPathToResultList(CountedResult<Map<String, Object>> result, String executionDirPath) {
        if (result.getTotal() > 0L) {
            ((Map)result.getData().get(0)).put("executionDirPath", executionDirPath);
        } else {
            result.getData().add(Collections.singletonMap("executionDirPath", executionDirPath));
        }
    }

    private static Map<List<RpaCommand>, SideFileType> divideCommandsBasedOnTryCatchOccurrences(List<RpaCommand> rpaCommands) {
        LinkedHashMap<List<RpaCommand>, SideFileType> rpaCommandsMap = new LinkedHashMap<List<RpaCommand>, SideFileType>();
        int searchFromPosition = 0;
        while (searchFromPosition < rpaCommands.size()) {
            OptionalInt tryPosition = IntStream.range(searchFromPosition, rpaCommands.size()).filter(i -> ((RpaCommand)rpaCommands.get(i)).getCommand().equals("try")).findFirst();
            if (tryPosition.isPresent()) {
                if (tryPosition.getAsInt() > searchFromPosition) {
                    rpaCommandsMap.put(rpaCommands.subList(searchFromPosition, tryPosition.getAsInt()), SideFileType.NORMAL);
                }
                OptionalInt catchPosition = IntStream.range(tryPosition.getAsInt(), rpaCommands.size()).filter(i -> ((RpaCommand)rpaCommands.get(i)).getCommand().equals("catch")).findFirst();
                OptionalInt endOfCatchPosition = IntStream.range(catchPosition.getAsInt(), rpaCommands.size()).filter(i -> ((RpaCommand)rpaCommands.get(i)).getCommand().equals("endCatch")).findFirst();
                rpaCommandsMap.put(rpaCommands.subList(tryPosition.getAsInt() + 1, catchPosition.getAsInt()), SideFileType.TRY_BLOCK);
                rpaCommandsMap.put(rpaCommands.subList(catchPosition.getAsInt() + 1, endOfCatchPosition.getAsInt()), SideFileType.CATCH_BLOCK);
                searchFromPosition = endOfCatchPosition.getAsInt() + 1;
                continue;
            }
            rpaCommandsMap.put(rpaCommands.subList(searchFromPosition, rpaCommands.size()), SideFileType.NORMAL);
            break;
        }
        return rpaCommandsMap;
    }

    public static boolean equalsTryCatchClauseCommand(String command) {
        return command.equals("try") || command.equals("catch") || command.equals("endCatch");
    }
}

