/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.util;

import java.util.function.Consumer;
import java.util.function.Function;

public final class LambdaExceptionUtil {
    public static <T, E extends Exception> Consumer<T> rethrowConsumer(Consumer_WithExceptions<T, E> consumer) throws E {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                LambdaExceptionUtil.throwAsUnchecked(exception);
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, R> rethrowFunction(Function_WithExceptions<T, R, E> function) throws E {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                LambdaExceptionUtil.throwAsUnchecked(exception);
                return null;
            }
        };
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    public static interface Consumer_WithExceptions<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    @FunctionalInterface
    public static interface Function_WithExceptions<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

