/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.upgrader;

import com.suncode.upgrader.change.task.Task;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FilenameUtils;

public class CopyChromeDriversToHomeDirectory
implements Task {
    private static final String HOME_DIRECTORY = "plusworkflow.home";

    public void run() {
        this.copyFile("seleniumwebdrivers/chromedriver.140.0.7339.80/chromedriver");
        this.copyFile("seleniumwebdrivers/chromedriver.140.0.7339.80/chromedriver.exe");
    }

    public void rollback() throws Exception {
    }

    private void copyFile(String fileToCopy) {
        try (InputStream fileInputStream = this.getClass().getClassLoader().getResource(fileToCopy).openStream();){
            Path destinationPath = Paths.get(System.getProperty(HOME_DIRECTORY), "chromeDriver", FilenameUtils.getName((String)fileToCopy));
            if (!Files.exists(destinationPath, new LinkOption[0])) {
                Files.createDirectories(destinationPath, new FileAttribute[0]);
            }
            Files.copy(fileInputStream, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

