/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.execution;

import com.suncode.plugin.datasource.rpa.collection.RpaCommand;
import com.suncode.plugin.datasource.rpa.driver.WebDriverType;
import com.suncode.pwfl.datasource.DataSourceParameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ExecutionParameters {
    private final List<RpaCommand> commands;
    private final String dataSourceId;
    private final int defaultTimeout;
    private final String[] driverArgs;
    private final String initialUrl;
    private final Set<DataSourceParameter> inputParameters;
    private final Set<DataSourceParameter> outputParameters;
    private final Map<String, String> values;
    private final WebDriverType webDriverType;

    ExecutionParameters(List<RpaCommand> commands, String dataSourceId, int defaultTimeout, String[] driverArgs, String initialUrl, Set<DataSourceParameter> inputParameters, Set<DataSourceParameter> outputParameters, Map<String, String> values, WebDriverType webDriverType) {
        this.commands = commands;
        this.dataSourceId = dataSourceId;
        this.defaultTimeout = defaultTimeout;
        this.driverArgs = driverArgs;
        this.initialUrl = initialUrl;
        this.inputParameters = inputParameters;
        this.outputParameters = outputParameters;
        this.values = values;
        this.webDriverType = webDriverType;
    }

    public static ExecutionParametersBuilder builder() {
        return new ExecutionParametersBuilder();
    }

    public List<RpaCommand> getCommands() {
        return this.commands;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public String[] getDriverArgs() {
        return this.driverArgs;
    }

    public String getInitialUrl() {
        return this.initialUrl;
    }

    public Set<DataSourceParameter> getInputParameters() {
        return this.inputParameters;
    }

    public Set<DataSourceParameter> getOutputParameters() {
        return this.outputParameters;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public WebDriverType getWebDriverType() {
        return this.webDriverType;
    }

    public static class ExecutionParametersBuilder {
        private List<RpaCommand> commands;
        private String dataSourceId;
        private int defaultTimeout;
        private String[] driverArgs;
        private String initialUrl;
        private Set<DataSourceParameter> inputParameters;
        private Set<DataSourceParameter> outputParameters;
        private Map<String, String> values;
        private WebDriverType webDriverType;

        ExecutionParametersBuilder() {
        }

        public ExecutionParametersBuilder commands(List<RpaCommand> commands) {
            this.commands = commands;
            return this;
        }

        public ExecutionParametersBuilder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public ExecutionParametersBuilder defaultTimeout(int defaultTimeout) {
            this.defaultTimeout = defaultTimeout;
            return this;
        }

        public ExecutionParametersBuilder driverArgs(String[] driverArgs) {
            this.driverArgs = driverArgs;
            return this;
        }

        public ExecutionParametersBuilder initialUrl(String initialUrl) {
            this.initialUrl = initialUrl;
            return this;
        }

        public ExecutionParametersBuilder inputParameters(Set<DataSourceParameter> inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public ExecutionParametersBuilder outputParameters(Set<DataSourceParameter> outputParameters) {
            this.outputParameters = outputParameters;
            return this;
        }

        public ExecutionParametersBuilder values(Map<String, String> values) {
            this.values = values;
            return this;
        }

        public ExecutionParametersBuilder webDriverType(WebDriverType webDriverType) {
            this.webDriverType = webDriverType;
            return this;
        }

        public ExecutionParameters build() {
            return new ExecutionParameters(this.commands, this.dataSourceId, this.defaultTimeout, this.driverArgs, this.initialUrl, this.inputParameters, this.outputParameters, this.values, this.webDriverType);
        }

        public String toString() {
            return "ExecutionParameters.ExecutionParametersBuilder(commands=" + this.commands + ", dataSourceId=" + this.dataSourceId + ", defaultTimeout=" + this.defaultTimeout + ", driverArgs=" + Arrays.deepToString(this.driverArgs) + ", initialUrl=" + this.initialUrl + ", inputParameters=" + this.inputParameters + ", outputParameters=" + this.outputParameters + ", values=" + this.values + ", webDriverType=" + this.webDriverType + ")";
        }
    }
}

