/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rpa.component;

import com.suncode.plugin.datasource.rpa.util.RpaUtil;
import com.suncode.pwfl.datasource.DataSourceValidateException;
import com.suncode.pwfl.datasource.DataSourceValidator;
import com.suncode.pwfl.datasource.dao.DataSourceDeclaration;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.workflow.component.declaration.ParameterDeclaration;
import com.suncode.pwfl.workflow.component.declaration.ParameterValue;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RpaDataSourceValidator
implements DataSourceValidator {
    private final Translator translator = Translators.get(RpaDataSourceValidator.class);

    public void validate(DataSourceDeclaration dataSourceDeclaration) {
        ParameterDeclaration commandParameterDeclaration = dataSourceDeclaration.getParameter("command");
        List commands = (List)commandParameterDeclaration.getValue();
        if (!this.tryCatchCommandExists(commands)) {
            return;
        }
        if (!this.checkIfTryCatchCommandsArePresentInSameNumber(commands)) {
            throw new DataSourceValidateException(this.translator.getMessage("rpaDatasource.validator.tryCatchCommandsNotPresentInSameNumber"));
        }
        if (!this.checkIfTryCatchCommandsAreInAppropriateSequence(commands)) {
            throw new DataSourceValidateException(this.translator.getMessage("rpaDatasource.validator.tryCatchCommandsNotInAppropriateSequence"));
        }
    }

    private boolean tryCatchCommandExists(List<ParameterValue> commands) {
        return commands.stream().map(ParameterValue::getValue).anyMatch(command -> RpaUtil.equalsTryCatchClauseCommand((String)command));
    }

    private boolean checkIfTryCatchCommandsArePresentInSameNumber(List<ParameterValue> commands) {
        Map groupedByCommands = commands.stream().map(ParameterValue::getValue).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        return groupedByCommands.get("try").longValue() == groupedByCommands.get("catch").longValue() && groupedByCommands.get("try").longValue() == groupedByCommands.get("endCatch").longValue();
    }

    private boolean checkIfTryCatchCommandsAreInAppropriateSequence(List<ParameterValue> commands) {
        List extractedTryCatchCommands = commands.stream().map(ParameterValue::getValue).filter(command -> RpaUtil.equalsTryCatchClauseCommand((String)command)).collect(Collectors.toCollection(LinkedList::new));
        for (int index = 0; index < extractedTryCatchCommands.size(); index += 3) {
            if (extractedTryCatchCommands.get(index).equals("try") && extractedTryCatchCommands.get(index + 1).equals("catch") && extractedTryCatchCommands.get(index + 2).equals("endCatch")) continue;
            return false;
        }
        return true;
    }
}

