/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.util.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.suncode.plugin.datasource.rest.component.auth.config.OAuthConfig;
import com.suncode.plugin.datasource.rest.component.auth.enums.OAuthConfigFieldKeys;
import java.lang.reflect.Type;

public class OAuthConfigDeserializer
implements JsonDeserializer<OAuthConfig> {
    public OAuthConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jObject = json.getAsJsonObject();
        String grantType = jObject.get(OAuthConfigFieldKeys.GRANT_TYPE_FIELD_KEY.toString()).getAsString();
        String accessTokenUrl = jObject.get(OAuthConfigFieldKeys.ACCESS_TOKEN_URL_FIELD_KEY.toString()).getAsString();
        String username = jObject.get(OAuthConfigFieldKeys.USERNAME_FIELD_KEY.toString()).getAsString();
        String password = jObject.get(OAuthConfigFieldKeys.PASSWORD_FIELD_KEY.toString()).getAsString();
        String clientId = jObject.get(OAuthConfigFieldKeys.CLIENT_ID_FIELD_KEY.toString()).getAsString();
        String clientSecret = jObject.get(OAuthConfigFieldKeys.CLIENT_SECRET_FIELD_KEY.toString()).getAsString();
        String scope = jObject.get(OAuthConfigFieldKeys.SCOPE_FIELD_KEY.toString()).getAsString();
        String resource = jObject.get(OAuthConfigFieldKeys.RESOURCE_FIELD_KEY.toString()).getAsString();
        String clientAuthentication = jObject.get(OAuthConfigFieldKeys.CLIENT_AUTHENTICATION_FIELD_KEY.toString()).getAsString();
        String addTo = jObject.get(OAuthConfigFieldKeys.ADD_TO_FIELD_KEY.toString()).getAsString();
        String token = jObject.get(OAuthConfigFieldKeys.TOKEN_FIELD_KEY.toString()).getAsString();
        return new OAuthConfig(grantType, accessTokenUrl, username, password, clientId, clientSecret, scope, resource, clientAuthentication, addTo, token);
    }
}

