/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.auth.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.suncode.plugin.datasource.rest.component.auth.config.ApiKeyConfig;
import com.suncode.plugin.datasource.rest.component.auth.config.BasicAuthConfig;
import com.suncode.plugin.datasource.rest.component.auth.config.BearerTokenConfig;
import com.suncode.plugin.datasource.rest.component.auth.config.CookieConfig;
import com.suncode.plugin.datasource.rest.component.auth.config.NTLMAuthConfig;
import com.suncode.plugin.datasource.rest.component.auth.config.OAuthConfig;
import com.suncode.plugin.datasource.rest.component.auth.dao.AuthorizationDao;
import com.suncode.plugin.datasource.rest.component.auth.domain.ApiKeyConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.domain.AuthorizationConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.domain.BasicAuthConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.domain.BearerTokenConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.domain.CookieConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.domain.NTLMAuthConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.domain.OAuthConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.dto.AuthorizationConfigurationDto;
import com.suncode.plugin.datasource.rest.component.auth.service.AuthorizationService;
import com.suncode.plugin.datasource.rest.util.deserializer.ApiKeyConfigDeserializer;
import com.suncode.plugin.datasource.rest.util.deserializer.BasicAuthConfigDeserializer;
import com.suncode.plugin.datasource.rest.util.deserializer.BearerTokenConfigDeserializer;
import com.suncode.plugin.datasource.rest.util.deserializer.CookieConfigDeserializer;
import com.suncode.plugin.datasource.rest.util.deserializer.NTLMConfigDeserializer;
import com.suncode.plugin.datasource.rest.util.deserializer.OAuthConfigDeserializer;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.support.hibernate.criterion.Criterion;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
@Provides(value={AuthorizationService.class})
public class AuthorizationServiceImpl
extends EditableServiceImpl<AuthorizationConfiguration, String, AuthorizationDao>
implements AuthorizationService {
    private final Gson gson = this.initializeGson();

    private final Gson initializeGson() {
        return new GsonBuilder().serializeNulls().registerTypeAdapter(ApiKeyConfig.class, (Object)new ApiKeyConfigDeserializer()).registerTypeAdapter(BasicAuthConfig.class, (Object)new BasicAuthConfigDeserializer()).registerTypeAdapter(BearerTokenConfig.class, (Object)new BearerTokenConfigDeserializer()).registerTypeAdapter(CookieConfig.class, (Object)new CookieConfigDeserializer()).registerTypeAdapter(OAuthConfig.class, (Object)new OAuthConfigDeserializer()).registerTypeAdapter(NTLMAuthConfig.class, (Object)new NTLMConfigDeserializer()).create();
    }

    @Autowired
    public void setDao(AuthorizationDao dao) {
        this.dao = dao;
    }

    @Override
    public CountedResult<AuthorizationConfigurationDto> getAuthorizations(String query, Sorter sorter, Integer start, Integer limit) {
        HibernateCriteria dc = HibernateCriteria.forClass(AuthorizationConfiguration.class);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            dc.add((Criterion)Restrictions.disjunction().add(Restrictions.ilike((String)"id", (Object)("%" + query + "%"))).add(Restrictions.ilike((String)"name", (Object)("%" + query + "%"))));
        }
        List configurations = ((AuthorizationDao)this.dao).findByCriteria(dc);
        CountedResult result = new CountedResult();
        result.setTotal((long)configurations.size());
        if (configurations.size() >= start) {
            result.setData(configurations.subList(start, Integer.min(configurations.size(), start + limit)).stream().map(AuthorizationConfigurationDto::fromModel).collect(Collectors.toList()));
        } else {
            result.setData(Collections.emptyList());
        }
        return result;
    }

    @Override
    public AuthorizationConfiguration getAuthorization(String id) {
        return (AuthorizationConfiguration)((AuthorizationDao)this.dao).get((Serializable)((Object)id));
    }

    @Override
    public void saveAuthorization(AuthorizationConfigurationDto authorizationDto) throws Exception {
        if (this.getAuthorization(authorizationDto.getId()) != null) {
            throw new Exception("Authorization configuration with id: " + authorizationDto.getId() + " already exists!");
        }
        AuthorizationConfiguration authorization = this.resolveConfiguration(authorizationDto);
        ((AuthorizationDao)this.dao).save(authorization);
    }

    @Override
    public void updateAuthorization(AuthorizationConfigurationDto authorizationDto) {
        AuthorizationConfiguration authorization = this.resolveConfiguration(authorizationDto);
        ((AuthorizationDao)this.dao).update(authorization);
    }

    @Override
    public void updateAuthorization(AuthorizationConfiguration authorization) {
        ((AuthorizationDao)this.dao).update(authorization);
    }

    @Override
    public void deleteAuthorization(String authorizationId) {
        AuthorizationConfiguration authorization = this.getAuthorization(authorizationId);
        if (authorization == null) {
            return;
        }
        ((AuthorizationDao)this.dao).delete(authorization);
    }

    private AuthorizationConfiguration resolveConfiguration(AuthorizationConfigurationDto authorizationDto) {
        switch (authorizationDto.getAuthorizationType()) {
            case API_KEY: {
                return this.createApiKeyConfiguration(authorizationDto);
            }
            case BASIC_AUTH: {
                return this.createBasicAuthConfiguration(authorizationDto);
            }
            case BEARER_TOKEN: {
                return this.createBearerTokenConfiguration(authorizationDto);
            }
            case COOKIE: {
                return this.createCookieConfiguration(authorizationDto);
            }
            case OAUTH2: {
                return this.createOAuthConfiguration(authorizationDto);
            }
            case NTLM: {
                return this.createNTLMConfiguration(authorizationDto);
            }
        }
        throw new IllegalArgumentException("Wrong authorization configuration provided!");
    }

    private AuthorizationConfiguration createNTLMConfiguration(AuthorizationConfigurationDto authorizationDto) {
        NTLMAuthConfig ntlmAuthConfig = (NTLMAuthConfig)this.gson.fromJson(authorizationDto.getAuthorizationConfig(), NTLMAuthConfig.class);
        return NTLMAuthConfiguration.builder().id(authorizationDto.getId()).name(authorizationDto.getName()).description(authorizationDto.getDescription()).username(ntlmAuthConfig.getUsername()).password(ntlmAuthConfig.getPassword()).domain(ntlmAuthConfig.getDomain()).workstation(ntlmAuthConfig.getWorkstation()).build();
    }

    private AuthorizationConfiguration createApiKeyConfiguration(AuthorizationConfigurationDto authorizationDto) {
        ApiKeyConfig apiKeyConfig = (ApiKeyConfig)this.gson.fromJson(authorizationDto.getAuthorizationConfig(), ApiKeyConfig.class);
        return ApiKeyConfiguration.builder().id(authorizationDto.getId()).name(authorizationDto.getName()).description(authorizationDto.getDescription()).key(apiKeyConfig.getKey()).value(apiKeyConfig.getValue()).addTo(apiKeyConfig.getAddTo()).build();
    }

    private AuthorizationConfiguration createBasicAuthConfiguration(AuthorizationConfigurationDto authorizationDto) {
        BasicAuthConfig basicAuthConfig = (BasicAuthConfig)this.gson.fromJson(authorizationDto.getAuthorizationConfig(), BasicAuthConfig.class);
        return BasicAuthConfiguration.builder().id(authorizationDto.getId()).name(authorizationDto.getName()).description(authorizationDto.getDescription()).username(basicAuthConfig.getUsername()).password(basicAuthConfig.getPassword()).build();
    }

    private AuthorizationConfiguration createBearerTokenConfiguration(AuthorizationConfigurationDto authorizationDto) {
        BearerTokenConfig bearerTokenConfig = (BearerTokenConfig)this.gson.fromJson(authorizationDto.getAuthorizationConfig(), BearerTokenConfig.class);
        return BearerTokenConfiguration.builder().id(authorizationDto.getId()).name(authorizationDto.getName()).description(authorizationDto.getDescription()).token(bearerTokenConfig.getToken()).datasourceId(bearerTokenConfig.getDatasourceId()).datasourceParameters(bearerTokenConfig.getDatasourceParameters()).tokenSource(bearerTokenConfig.getTokenSource()).build();
    }

    private AuthorizationConfiguration createCookieConfiguration(AuthorizationConfigurationDto authorizationDto) {
        CookieConfig cookieConfig = (CookieConfig)this.gson.fromJson(authorizationDto.getAuthorizationConfig(), CookieConfig.class);
        return CookieConfiguration.builder().id(authorizationDto.getId()).name(authorizationDto.getName()).description(authorizationDto.getDescription()).contentType(cookieConfig.getContentType()).header(cookieConfig.getHeader()).httpMethod(cookieConfig.getHttpMethod()).parameters(cookieConfig.getParameters()).url(cookieConfig.getUrl()).build();
    }

    private AuthorizationConfiguration createOAuthConfiguration(AuthorizationConfigurationDto authorizationDto) {
        OAuthConfig oauthConfig = (OAuthConfig)this.gson.fromJson(authorizationDto.getAuthorizationConfig(), OAuthConfig.class);
        return OAuthConfiguration.builder().id(authorizationDto.getId()).name(authorizationDto.getName()).description(authorizationDto.getDescription()).accessTokenUrl(oauthConfig.getAccessTokenUrl()).addTo(oauthConfig.getAddTo()).clientAuthentication(oauthConfig.getClientAuthentication()).clientId(oauthConfig.getClientId()).clientSecret(oauthConfig.getClientSecret()).grantType(oauthConfig.getGrantType()).password(oauthConfig.getPassword()).resource(oauthConfig.getResource()).scope(oauthConfig.getScope()).token(oauthConfig.getToken()).username(oauthConfig.getUsername()).build();
    }
}

