/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.auth.domain;

import com.suncode.plugin.datasource.rest.component.auth.domain.AuthorizationConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.enums.AuthorizationType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="pm_ds_rest_cookie_config")
public class CookieConfiguration
extends AuthorizationConfiguration {
    @Column
    private String header;
    @Column
    private String httpMethod;
    @Column
    private String url;
    @Column
    private String contentType;
    @Column(length=4000)
    private String parameters;

    public CookieConfiguration(String id, String name, String description, String header, String httpMethod, String url, String contentType, String parameters) {
        super(id, name, description, AuthorizationType.COOKIE);
        this.header = header;
        this.httpMethod = httpMethod;
        this.url = url;
        this.contentType = contentType;
        this.parameters = parameters;
    }

    public static CookieConfigurationBuilder builder() {
        return new CookieConfigurationBuilder();
    }

    public CookieConfiguration() {
    }

    public String getHeader() {
        return this.header;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public static class CookieConfigurationBuilder {
        private String id;
        private String name;
        private String description;
        private String header;
        private String httpMethod;
        private String url;
        private String contentType;
        private String parameters;

        CookieConfigurationBuilder() {
        }

        public CookieConfigurationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public CookieConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CookieConfigurationBuilder description(String description) {
            this.description = description;
            return this;
        }

        public CookieConfigurationBuilder header(String header) {
            this.header = header;
            return this;
        }

        public CookieConfigurationBuilder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public CookieConfigurationBuilder url(String url) {
            this.url = url;
            return this;
        }

        public CookieConfigurationBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public CookieConfigurationBuilder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public CookieConfiguration build() {
            return new CookieConfiguration(this.id, this.name, this.description, this.header, this.httpMethod, this.url, this.contentType, this.parameters);
        }

        public String toString() {
            return "CookieConfiguration.CookieConfigurationBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", header=" + this.header + ", httpMethod=" + this.httpMethod + ", url=" + this.url + ", contentType=" + this.contentType + ", parameters=" + this.parameters + ")";
        }
    }
}

