/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.auth.controller;

import com.suncode.plugin.datasource.rest.component.auth.dto.AuthorizationConfigurationDto;
import com.suncode.plugin.datasource.rest.component.auth.service.AuthorizationService;
import com.suncode.plugin.datasource.rest.util.dto.SortDto;
import com.suncode.plugin.datasource.rest.util.translator.TranslatorWrapper;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.support.ajax.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"authorizations"})
public class AuthorizationController {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationController.class);
    @Autowired
    private AuthorizationService authorizationService;
    @Autowired
    private TranslatorWrapper translator;

    @Transactional
    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<AuthorizationConfigurationDto> getAuthorizations(@RequestParam(required=false) String query, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, SortDto sort) {
        return this.authorizationService.getAuthorizations(query, sort.getSorter(), start, limit);
    }

    @Transactional
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public RestResult createAuthorization(@RequestBody AuthorizationConfigurationDto authorization) throws Exception {
        log.debug("Creating authorization: " + authorization);
        try {
            this.authorizationService.saveAuthorization(authorization);
            return new RestResult(true, this.translator.getMessage("restDatasource.authorizationCreated"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RestResult(false, this.translator.getMessage("restDatasource.authorizationExists", authorization.getId()));
        }
    }

    @Transactional
    @RequestMapping(value={"{authorizationId}"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult modifyAuthorization(@PathVariable String authorizationId, @RequestBody AuthorizationConfigurationDto modifiedAuthorization) throws Exception {
        log.debug("Updating authorization: " + authorizationId + " | " + modifiedAuthorization);
        try {
            this.authorizationService.updateAuthorization(modifiedAuthorization);
            return new RestResult(true, this.translator.getMessage("restDatasource.authorizationModified"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RestResult(false, this.translator.getMessage("restDatasource.authorizationNotExists", authorizationId));
        }
    }

    @Transactional
    @RequestMapping(value={"{authorizationId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteAuthorization(@PathVariable String authorizationId) {
        log.debug("Deleting authorization: " + authorizationId);
        this.authorizationService.deleteAuthorization(authorizationId);
        return new RestResult(true, this.translator.getMessage("restDatasource.authorizationDeleted"));
    }
}

