/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.auth.authenticator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.suncode.plugin.datasource.rest.component.auth.config.CookieConfig;
import com.suncode.plugin.datasource.rest.component.auth.domain.CookieConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.service.AuthorizationService;
import com.suncode.plugin.datasource.rest.util.serializer.CookieConfigSerializer;
import java.io.IOException;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;

public class CookieAuthenticator
implements Authenticator {
    private final AuthorizationService authorizationService;
    private final CookieConfiguration config;

    public CookieAuthenticator(AuthorizationService authorizationService, CookieConfiguration config) {
        this.authorizationService = authorizationService;
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Request authenticate(Route route, Response response) throws IOException {
        OkHttpClient client = new OkHttpClient();
        Request.Builder authRequestBuilder = new Request.Builder();
        authRequestBuilder.url(this.config.getUrl()).method(this.config.getHttpMethod(), this.getRequestBody());
        try (Response res = client.newCall(authRequestBuilder.build()).execute();){
            if (res.isSuccessful()) {
                String cookieHeader = res.header("Set-Cookie");
                this.config.setHeader(cookieHeader);
                GsonBuilder gsonBuilder = new GsonBuilder();
                gsonBuilder.registerTypeAdapter(CookieConfig.class, (Object)new CookieConfigSerializer());
                this.authorizationService.updateAuthorization(this.config);
                Request request = response.request().newBuilder().header("Cookie", cookieHeader).build();
                return request;
            }
            Request request = null;
            return request;
        }
    }

    private RequestBody getRequestBody() {
        if (this.config.getHttpMethod().equalsIgnoreCase("GET")) {
            return null;
        }
        if (this.config.getContentType().equalsIgnoreCase("json")) {
            return RequestBody.create((String)this.config.getParameters(), (MediaType)MediaType.parse((String)"application/json"));
        }
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        Map parametersMap = (Map)new Gson().fromJson(this.config.getParameters(), new TypeToken<Map<String, String>>(){}.getType());
        if (this.config.getContentType().equalsIgnoreCase("form-data")) {
            parametersMap.forEach((arg_0, arg_1) -> ((FormBody.Builder)formBodyBuilder).add(arg_0, arg_1));
        }
        if (this.config.getContentType().equalsIgnoreCase("form-encoded")) {
            parametersMap.forEach((arg_0, arg_1) -> ((FormBody.Builder)formBodyBuilder).addEncoded(arg_0, arg_1));
        }
        return formBodyBuilder.build();
    }
}

