/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.util.interceptors;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

public class SetContentTypeInterceptor
implements Interceptor {
    private final String contentType;

    public SetContentTypeInterceptor(String contentType) {
        this.contentType = contentType;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.contentType != null) {
            return chain.proceed(request.newBuilder().method(request.method(), this.modifyContentType(request.body(), this.contentType)).build());
        }
        return chain.proceed(request);
    }

    private RequestBody modifyContentType(final RequestBody requestBody, final String contentType) {
        return new RequestBody(){

            public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
                requestBody.writeTo(bufferedSink);
            }

            public MediaType contentType() {
                return MediaType.get((String)contentType);
            }
        };
    }
}

