/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.parsers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.reflect.TypeToken;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.suncode.plugin.datasource.rest.component.auth.domain.AuthorizationConfiguration;
import com.suncode.plugin.datasource.rest.component.enums.ParamType;
import com.suncode.plugin.datasource.rest.util.parameters.QueryParameter;
import com.suncode.plugin.datasource.rest.util.parameters.UploadFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minidev.json.JSONObject;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParametersParser {
    private static final Logger log = LoggerFactory.getLogger(RequestParametersParser.class);
    private static final Tika TIKA = new Tika();
    private static final String PATTERN_GROUP_NAME = "token";
    private static final String PRIMITIVE_TOKEN_PATTERN = "\\{(?<token>[A-Za-z0-9-_]+)}";
    private static final String STRING_TOKEN_PATTERN = "\"\\{(?<token>[A-Za-z0-9-_]+)}\"";
    private static final String REPLACE_PRIMITIVE_TOKEN_PATTERN = "\"\\[(?<token>[A-Za-z0-9-_]+)]\"";
    private static final String REPLACE_ALL_TOKEN_PATTERN = "(\\\\)?\"\\[(?<token>[A-Za-z0-9-_]+)](\\\\)?\"";
    private static final String REPLACE_STRING_TOKEN_PATTERN = "\\\\\"\\[(?<token>[A-Za-z0-9-_]+)]\\\\\"";
    private static final String NO_WHITE_SPACES_PATTERN = "\\h(?=[\\h\":{}])";
    private static final Gson GSON = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).serializeNulls().create();

    private RequestParametersParser() {
    }

    public static RequestBody parseBodyParams(List<QueryParameter> queryParameters, Map<String, String> parameters, String contentType, String schema, String splitCharacter, List<UploadFile> filesToUpload) {
        switch (contentType) {
            case "formData": {
                MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder();
                multipartBodyBuilder.setType(MultipartBody.FORM);
                for (QueryParameter queryParameter : queryParameters) {
                    if (!queryParameter.getType().equals(ParamType.BODY_PARAM.getValue())) continue;
                    multipartBodyBuilder.addFormDataPart(queryParameter.getId(), parameters.get(queryParameter.getId()));
                }
                filesToUpload.forEach(fileToUpload -> multipartBodyBuilder.addFormDataPart(fileToUpload.getKey(), fileToUpload.getFile().getName(), RequestBody.create((File)fileToUpload.getFile(), (MediaType)RequestParametersParser.getMediaType(fileToUpload.getFile()))));
                return multipartBodyBuilder.build();
            }
            case "formUrlencoded": {
                FormBody.Builder formBodyBuilder = new FormBody.Builder();
                IntStream.range(0, queryParameters.size()).boxed().forEach(i -> formBodyBuilder.addEncoded(((QueryParameter)queryParameters.get((int)i)).getId(), (String)parameters.get(((QueryParameter)queryParameters.get((int)i)).getId())));
                return formBodyBuilder.build();
            }
        }
        return RequestBody.create((String)RequestParametersParser.getJsonString(queryParameters, parameters, schema, splitCharacter), (MediaType)MediaType.get((String)"application/json;charset=utf-8"));
    }

    public static String getJsonString(List<QueryParameter> queryParameters, Map<String, String> parameters, String schema, String splitCharacter) {
        if (StringUtils.isEmpty((String)schema.trim())) {
            return GSON.toJson(IntStream.range(0, queryParameters.size()).boxed().filter(i -> ((QueryParameter)queryParameters.get((int)i)).getType().equals(ParamType.BODY_PARAM.getValue())).collect(Collectors.toMap(i -> ((QueryParameter)queryParameters.get((int)i)).getId(), i -> (String)parameters.get(((QueryParameter)queryParameters.get((int)i)).getId()))));
        }
        String noWhiteSpaces = schema.replaceAll(NO_WHITE_SPACES_PATTERN, "");
        String escapedJsonStrings = RequestParametersParser.escapeJsonString(noWhiteSpaces, parameters);
        String escapedJsonPrimitives = RequestParametersParser.escapeJsonPrimitives(escapedJsonStrings, parameters);
        if (!RequestParametersParser.validateJsonString(escapedJsonPrimitives)) {
            throw new JsonSyntaxException("Error: Malformed JSON schema string!");
        }
        return RequestParametersParser.modifyJson(escapedJsonPrimitives, RequestParametersParser.filterQueryParameters(queryParameters), parameters, splitCharacter);
    }

    private static MediaType getMediaType(File file) {
        String mimeType = TIKA.detect(file);
        return MediaType.parse((String)mimeType);
    }

    private static String escapeJsonPrimitives(String json, Map<String, String> parameters) {
        return RequestParametersParser.replaceTokenInString(json, Pattern.compile(PRIMITIVE_TOKEN_PATTERN), match -> {
            String paramId = parameters.keySet().stream().filter(key -> key.equals(match.group(PATTERN_GROUP_NAME))).findFirst().orElse(null);
            if (paramId != null) {
                paramId = "\"[" + paramId + "]\"";
            }
            return paramId;
        });
    }

    private static String escapeJsonString(String json, Map<String, String> parameters) {
        return RequestParametersParser.replaceTokenInString(json, Pattern.compile(STRING_TOKEN_PATTERN), match -> {
            String paramId = parameters.keySet().stream().filter(key -> key.equals(match.group(PATTERN_GROUP_NAME))).findFirst().orElse(null);
            if (paramId != null) {
                paramId = "\"\\\"[" + paramId + "]\\\"\"";
            }
            return paramId;
        });
    }

    private static boolean validateJsonString(String json) {
        try {
            GSON.getAdapter(JsonElement.class).fromJson(json);
        }
        catch (JsonSyntaxException | IOException e) {
            return false;
        }
        return true;
    }

    public static String replaceInputParameter(String param, ParamType paramType, List<QueryParameter> queryParameters, Map<String, String> parameters, Function<String, String> modifier) {
        for (QueryParameter queryParameter : queryParameters) {
            if (!queryParameter.getType().equals(paramType.getValue())) continue;
            param = param.replace("{" + queryParameter.getId() + "}", modifier.apply(parameters.get(queryParameter.getId())));
        }
        return param;
    }

    public static void parseAuthorizationParams(AuthorizationConfiguration configuration, List<QueryParameter> queryParameters, Map<String, String> parameters) {
        try {
            Field[] fields = configuration.getClass().getDeclaredFields();
            for (QueryParameter queryParameter : queryParameters) {
                if (!queryParameter.getType().equalsIgnoreCase(ParamType.AUTH_PARAM.getValue())) continue;
                for (Field field : fields) {
                    String currentValue = BeanUtils.getProperty((Object)configuration, (String)field.getName());
                    if (!currentValue.contains(queryParameter.getId())) continue;
                    BeanUtils.setProperty((Object)configuration, (String)field.getName(), (Object)currentValue.replace("{" + queryParameter.getId() + "}", parameters.get(queryParameter.getId())));
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<QueryParameter> filterQueryParameters(List<QueryParameter> queryParameters) {
        return queryParameters.stream().filter(queryParameter -> queryParameter.getType().equals(ParamType.BODY_PARAM.getValue())).collect(Collectors.toList());
    }

    private static Map<String, List<String>> getArrayValueParameters(List<QueryParameter> queryParameters, Map<String, String> parameters, String splitCharacter) {
        return parameters.entrySet().stream().filter(entry -> queryParameters.stream().anyMatch(queryParameter -> !queryParameter.getJsonPath().isEmpty() && queryParameter.getId().equals(entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, entry -> Arrays.asList(JSONObject.escape((String)((String)entry.getValue())).split(splitCharacter, -1))));
    }

    private static Map<String, String> getSingleValueParameters(List<QueryParameter> queryParameters, Map<String, String> parameters) {
        return parameters.entrySet().stream().filter(entry -> queryParameters.stream().anyMatch(queryParameter -> queryParameter.getJsonPath().isEmpty() && queryParameter.getId().equals(entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, param -> JSONObject.escape((String)((String)param.getValue()))));
    }

    private static Map<String, List<String>> getQueryParametersIdByJsonPath(List<QueryParameter> queryParameters) {
        return queryParameters.stream().filter(queryParameter -> StringUtils.isNotBlank((String)queryParameter.getJsonPath())).collect(Collectors.groupingBy(QueryParameter::getJsonPath)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(QueryParameter::getId).collect(Collectors.toList())));
    }

    private static String modifyJson(String schema, List<QueryParameter> queryParameters, Map<String, String> parameters, String splitCharacter) {
        Map<String, String> singleValueParameters = RequestParametersParser.getSingleValueParameters(queryParameters, parameters);
        Map<String, List<String>> arrayValueParameters = RequestParametersParser.getArrayValueParameters(queryParameters, parameters, splitCharacter);
        Map<String, List<String>> queryParametersIdByJsonPath = RequestParametersParser.getQueryParametersIdByJsonPath(queryParameters);
        String updatedSchema = RequestParametersParser.replaceTokenInString(schema, Pattern.compile(REPLACE_ALL_TOKEN_PATTERN), match -> (String)singleValueParameters.get(match.group(PATTERN_GROUP_NAME)));
        DocumentContext jsonContext = JsonPath.parse((String)updatedSchema);
        queryParametersIdByJsonPath.forEach((key, value) -> {
            if (!JsonPath.compile((String)key, (Predicate[])new Predicate[0]).isDefinite()) {
                throw new IllegalArgumentException("Indefinite path found: " + key);
            }
            List list = arrayValueParameters.entrySet().stream().filter(en -> value.contains(en.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            if (!list.stream().allMatch(l -> l.size() == ((List)list.get(0)).size())) {
                throw new IllegalArgumentException("Arrays lengths are not equal!");
            }
        });
        queryParametersIdByJsonPath.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("$")).sorted((o1, o2) -> Long.compare(((String)o1.getKey()).chars().filter(ch -> ch == 46).count(), ((String)o2.getKey()).chars().filter(ch -> ch == 46).count())).forEach(entry -> {
            Object jsonElements = jsonContext.read((String)entry.getKey(), new Predicate[0]);
            if (!(jsonElements instanceof List)) {
                throw new IllegalArgumentException("Array not found at: " + (String)entry.getKey());
            }
            List<Object> result = RequestParametersParser.replaceTokens(arrayValueParameters, (List)entry.getValue(), jsonElements);
            jsonContext.set((String)entry.getKey(), result, new Predicate[0]);
        });
        Optional<Map.Entry> rootElementIds = queryParametersIdByJsonPath.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("$")).findFirst();
        if (rootElementIds.isPresent()) {
            Object jsonElements = jsonContext.read((String)rootElementIds.get().getKey(), new Predicate[0]);
            if (!(jsonElements instanceof List)) {
                throw new IllegalArgumentException("Array not found at: " + (String)rootElementIds.get().getKey());
            }
            List<Object> result = RequestParametersParser.replaceTokens(arrayValueParameters, (List)rootElementIds.get().getValue(), jsonElements);
            return JsonPath.parse((String)GSON.toJson(result)).jsonString();
        }
        log.info("Result JSON string: {}", (Object)jsonContext.jsonString());
        return jsonContext.jsonString();
    }

    private static List<Object> replaceTokens(Map<String, List<String>> arrayParameters, List<String> ids, Object element) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (element instanceof List) {
            ((List)element).forEach(el -> result.addAll(RequestParametersParser.replaceTokens(arrayParameters, ids, el)));
        } else if (element instanceof Map) {
            result.addAll(RequestParametersParser.replaceTokensInJsonMap(GSON.toJson(element), Pattern.compile(REPLACE_ALL_TOKEN_PATTERN), match -> arrayParameters.entrySet().stream().filter(entry -> ids.contains(entry.getKey())).filter(entry -> ((String)entry.getKey()).equals(match.group(PATTERN_GROUP_NAME))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        } else {
            result.add(element);
        }
        return result;
    }

    private static List<Map<String, Object>> replaceTokensInJsonMap(String original, Pattern tokenPattern, Function<Matcher, Map<String, List<String>>> converter) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Matcher matcher = tokenPattern.matcher(original);
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        HashMap<String, List<String>> allMatches = new HashMap<String, List<String>>();
        ArrayList jsonStrings = new ArrayList();
        int numberOfCopies = 0;
        while (matcher.find()) {
            Map<String, List<String>> matches = converter.apply(matcher);
            if (matches == null || matches.isEmpty()) continue;
            allMatches.putAll(matches);
            numberOfCopies = ((List)((Map.Entry)matches.entrySet().stream().findFirst().get()).getValue()).size();
        }
        IntStream.range(0, numberOfCopies).forEach(operand -> jsonStrings.add(original));
        AtomicInteger counter = new AtomicInteger();
        jsonStrings.forEach(jsonString -> {
            String swappedStrings = RequestParametersParser.replaceTokenInString(jsonString, Pattern.compile(REPLACE_STRING_TOKEN_PATTERN), match -> allMatches.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(match.group(PATTERN_GROUP_NAME))).filter(entry -> ((List)entry.getValue()).size() > counter.get()).map(entry -> (String)((List)entry.getValue()).get(counter.get())).findFirst().orElse(""));
            String swappedPrimitives = RequestParametersParser.replaceTokenInString(swappedStrings, Pattern.compile(REPLACE_PRIMITIVE_TOKEN_PATTERN), match -> allMatches.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(match.group(PATTERN_GROUP_NAME))).filter(entry -> ((List)entry.getValue()).size() > counter.get()).map(entry -> (String)((List)entry.getValue()).get(counter.get())).filter(s -> !s.isEmpty()).findFirst().orElse("null"));
            list.add((Map<String, Object>)GSON.fromJson(swappedPrimitives, type));
            counter.getAndIncrement();
        });
        return list;
    }

    private static String replaceTokenInString(String original, Pattern tokenPattern, Function<Matcher, String> converter) {
        int lastIndex = 0;
        StringBuilder output = new StringBuilder();
        Matcher matcher = tokenPattern.matcher(original);
        while (matcher.find()) {
            String value = converter.apply(matcher);
            if (value == null) continue;
            output.append(original, lastIndex, matcher.start()).append(converter.apply(matcher));
            lastIndex = matcher.end();
        }
        if (lastIndex < original.length()) {
            output.append(original, lastIndex, original.length());
        }
        return output.toString();
    }

    public static Map<String, String> parseHeaderParams(Map<String, String> staticHeaders, List<QueryParameter> queryParameters, Map<String, String> parameters) {
        return staticHeaders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> RequestParametersParser.replaceTokenInString((String)entry.getValue(), Pattern.compile(PRIMITIVE_TOKEN_PATTERN), match -> queryParameters.stream().filter(queryParameter -> queryParameter.getType().equals(ParamType.HEADER_PARAM.getValue())).collect(Collectors.toMap(QueryParameter::getId, o -> (String)parameters.get(o.getId()))).get(match.group(PATTERN_GROUP_NAME)))));
    }
}

