/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.auth.domain;

import com.suncode.plugin.datasource.rest.component.auth.domain.AuthorizationConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.enums.AuthorizationType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="pm_ds_rest_oauth_config")
public class OAuthConfiguration
extends AuthorizationConfiguration {
    @Column
    private String grantType;
    @Column
    private String accessTokenUrl;
    @Column
    private String username;
    @Column
    private String password;
    @Column
    private String clientId;
    @Column
    private String clientSecret;
    @Column
    private String scope;
    @Column(name="oauthresource")
    private String resource;
    @Column
    private String clientAuthentication;
    @Column
    private String addTo;
    @Column(length=4000)
    private String token;

    public OAuthConfiguration(String id, String name, String description, String grantType, String accessTokenUrl, String username, String password, String clientId, String clientSecret, String scope, String resource, String clientAuthentication, String addTo, String token) {
        super(id, name, description, AuthorizationType.OAUTH2);
        this.accessTokenUrl = accessTokenUrl;
        this.addTo = addTo;
        this.clientAuthentication = clientAuthentication;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.grantType = grantType;
        this.password = password;
        this.resource = resource;
        this.scope = scope;
        this.token = token;
        this.username = username;
    }

    public static OAuthConfigurationBuilder builder() {
        return new OAuthConfigurationBuilder();
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getScope() {
        return this.scope;
    }

    public String getResource() {
        return this.resource;
    }

    public String getClientAuthentication() {
        return this.clientAuthentication;
    }

    public String getAddTo() {
        return this.addTo;
    }

    public String getToken() {
        return this.token;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setClientAuthentication(String clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }

    public void setAddTo(String addTo) {
        this.addTo = addTo;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public OAuthConfiguration() {
    }

    public static class OAuthConfigurationBuilder {
        private String id;
        private String name;
        private String description;
        private String grantType;
        private String accessTokenUrl;
        private String username;
        private String password;
        private String clientId;
        private String clientSecret;
        private String scope;
        private String resource;
        private String clientAuthentication;
        private String addTo;
        private String token;

        OAuthConfigurationBuilder() {
        }

        public OAuthConfigurationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public OAuthConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OAuthConfigurationBuilder description(String description) {
            this.description = description;
            return this;
        }

        public OAuthConfigurationBuilder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public OAuthConfigurationBuilder accessTokenUrl(String accessTokenUrl) {
            this.accessTokenUrl = accessTokenUrl;
            return this;
        }

        public OAuthConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        public OAuthConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        public OAuthConfigurationBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public OAuthConfigurationBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public OAuthConfigurationBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public OAuthConfigurationBuilder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public OAuthConfigurationBuilder clientAuthentication(String clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public OAuthConfigurationBuilder addTo(String addTo) {
            this.addTo = addTo;
            return this;
        }

        public OAuthConfigurationBuilder token(String token) {
            this.token = token;
            return this;
        }

        public OAuthConfiguration build() {
            return new OAuthConfiguration(this.id, this.name, this.description, this.grantType, this.accessTokenUrl, this.username, this.password, this.clientId, this.clientSecret, this.scope, this.resource, this.clientAuthentication, this.addTo, this.token);
        }

        public String toString() {
            return "OAuthConfiguration.OAuthConfigurationBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", grantType=" + this.grantType + ", accessTokenUrl=" + this.accessTokenUrl + ", username=" + this.username + ", password=" + this.password + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", scope=" + this.scope + ", resource=" + this.resource + ", clientAuthentication=" + this.clientAuthentication + ", addTo=" + this.addTo + ", token=" + this.token + ")";
        }
    }
}

