/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.auth.domain;

import com.suncode.plugin.datasource.rest.component.auth.domain.AuthorizationConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.enums.AuthorizationType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="pm_ds_rest_ntlm_auth_config")
public class NTLMAuthConfiguration
extends AuthorizationConfiguration {
    @Column
    private String username;
    @Column
    private String password;
    @Column
    private String domain;
    @Column
    private String workstation;

    public NTLMAuthConfiguration(String id, String name, String description, String username, String password, String domain, String workstation) {
        super(id, name, description, AuthorizationType.NTLM);
        this.username = username;
        this.password = password;
        this.domain = domain;
        this.workstation = workstation;
    }

    public static NTLMAuthConfigurationBuilder builder() {
        return new NTLMAuthConfigurationBuilder();
    }

    public NTLMAuthConfiguration() {
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setWorkstation(String workstation) {
        this.workstation = workstation;
    }

    public static class NTLMAuthConfigurationBuilder {
        private String id;
        private String name;
        private String description;
        private String username;
        private String password;
        private String domain;
        private String workstation;

        NTLMAuthConfigurationBuilder() {
        }

        public NTLMAuthConfigurationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public NTLMAuthConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NTLMAuthConfigurationBuilder description(String description) {
            this.description = description;
            return this;
        }

        public NTLMAuthConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        public NTLMAuthConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        public NTLMAuthConfigurationBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public NTLMAuthConfigurationBuilder workstation(String workstation) {
            this.workstation = workstation;
            return this;
        }

        public NTLMAuthConfiguration build() {
            return new NTLMAuthConfiguration(this.id, this.name, this.description, this.username, this.password, this.domain, this.workstation);
        }

        public String toString() {
            return "NTLMAuthConfiguration.NTLMAuthConfigurationBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", username=" + this.username + ", password=" + this.password + ", domain=" + this.domain + ", workstation=" + this.workstation + ")";
        }
    }
}

