/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.auth.domain;

import com.suncode.plugin.datasource.rest.component.auth.domain.AuthorizationConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.enums.AuthorizationType;
import com.suncode.plugin.datasource.rest.component.auth.enums.TokenSource;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;

@Entity
@Table(name="pm_ds_rest_bearer_token_config")
public class BearerTokenConfiguration
extends AuthorizationConfiguration {
    @Column(length=4000)
    private String token;
    @Column
    private String datasourceId;
    @Column(length=4000)
    private String datasourceParameters;
    @Column
    @Enumerated(value=EnumType.STRING)
    private TokenSource tokenSource;

    public BearerTokenConfiguration(String id, String name, String description, String token, String datasourceId, String datasourceParameters, TokenSource tokenSource) {
        super(id, name, description, AuthorizationType.BEARER_TOKEN);
        this.token = token;
        this.datasourceId = datasourceId;
        this.datasourceParameters = datasourceParameters;
        this.tokenSource = tokenSource;
    }

    public static BearerTokenConfigurationBuilder builder() {
        return new BearerTokenConfigurationBuilder();
    }

    public BearerTokenConfiguration() {
    }

    public String getToken() {
        return this.token;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public String getDatasourceParameters() {
        return this.datasourceParameters;
    }

    public TokenSource getTokenSource() {
        return this.tokenSource;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public void setDatasourceParameters(String datasourceParameters) {
        this.datasourceParameters = datasourceParameters;
    }

    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = tokenSource;
    }

    public static class BearerTokenConfigurationBuilder {
        private String id;
        private String name;
        private String description;
        private String token;
        private String datasourceId;
        private String datasourceParameters;
        private TokenSource tokenSource;

        BearerTokenConfigurationBuilder() {
        }

        public BearerTokenConfigurationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public BearerTokenConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BearerTokenConfigurationBuilder description(String description) {
            this.description = description;
            return this;
        }

        public BearerTokenConfigurationBuilder token(String token) {
            this.token = token;
            return this;
        }

        public BearerTokenConfigurationBuilder datasourceId(String datasourceId) {
            this.datasourceId = datasourceId;
            return this;
        }

        public BearerTokenConfigurationBuilder datasourceParameters(String datasourceParameters) {
            this.datasourceParameters = datasourceParameters;
            return this;
        }

        public BearerTokenConfigurationBuilder tokenSource(TokenSource tokenSource) {
            this.tokenSource = tokenSource;
            return this;
        }

        public BearerTokenConfiguration build() {
            return new BearerTokenConfiguration(this.id, this.name, this.description, this.token, this.datasourceId, this.datasourceParameters, this.tokenSource);
        }

        public String toString() {
            return "BearerTokenConfiguration.BearerTokenConfigurationBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", token=" + this.token + ", datasourceId=" + this.datasourceId + ", datasourceParameters=" + this.datasourceParameters + ", tokenSource=" + (Object)((Object)this.tokenSource) + ")";
        }
    }
}

