/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.auth.domain;

import com.suncode.plugin.datasource.rest.component.auth.domain.AuthorizationConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.enums.AuthorizationType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="pm_ds_rest_basic_auth_config")
public class BasicAuthConfiguration
extends AuthorizationConfiguration {
    @Column
    private String username;
    @Column
    private String password;

    public BasicAuthConfiguration(String id, String name, String description, String username, String password) {
        super(id, name, description, AuthorizationType.BASIC_AUTH);
        this.username = username;
        this.password = password;
    }

    public static BasicAuthConfigurationBuilder builder() {
        return new BasicAuthConfigurationBuilder();
    }

    public BasicAuthConfiguration() {
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static class BasicAuthConfigurationBuilder {
        private String id;
        private String name;
        private String description;
        private String username;
        private String password;

        BasicAuthConfigurationBuilder() {
        }

        public BasicAuthConfigurationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public BasicAuthConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BasicAuthConfigurationBuilder description(String description) {
            this.description = description;
            return this;
        }

        public BasicAuthConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        public BasicAuthConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        public BasicAuthConfiguration build() {
            return new BasicAuthConfiguration(this.id, this.name, this.description, this.username, this.password);
        }

        public String toString() {
            return "BasicAuthConfiguration.BasicAuthConfigurationBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

