/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.auth.domain;

import com.suncode.plugin.datasource.rest.component.auth.domain.AuthorizationConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.enums.AuthorizationType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="pm_ds_rest_api_key_config")
public class ApiKeyConfiguration
extends AuthorizationConfiguration {
    @Column(name="apikey")
    private String key;
    @Column(length=4000)
    private String value;
    @Column
    private String addTo;

    public ApiKeyConfiguration(String id, String name, String description, String key, String value, String addTo) {
        super(id, name, description, AuthorizationType.API_KEY);
        this.key = key;
        this.value = value;
        this.addTo = addTo;
    }

    public static ApiKeyConfigurationBuilder builder() {
        return new ApiKeyConfigurationBuilder();
    }

    public ApiKeyConfiguration() {
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getAddTo() {
        return this.addTo;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setAddTo(String addTo) {
        this.addTo = addTo;
    }

    public static class ApiKeyConfigurationBuilder {
        private String id;
        private String name;
        private String description;
        private String key;
        private String value;
        private String addTo;

        ApiKeyConfigurationBuilder() {
        }

        public ApiKeyConfigurationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ApiKeyConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ApiKeyConfigurationBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ApiKeyConfigurationBuilder key(String key) {
            this.key = key;
            return this;
        }

        public ApiKeyConfigurationBuilder value(String value) {
            this.value = value;
            return this;
        }

        public ApiKeyConfigurationBuilder addTo(String addTo) {
            this.addTo = addTo;
            return this;
        }

        public ApiKeyConfiguration build() {
            return new ApiKeyConfiguration(this.id, this.name, this.description, this.key, this.value, this.addTo);
        }

        public String toString() {
            return "ApiKeyConfiguration.ApiKeyConfigurationBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", key=" + this.key + ", value=" + this.value + ", addTo=" + this.addTo + ")";
        }
    }
}

