/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.auth.authenticator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.suncode.plugin.datasource.rest.component.auth.config.OAuthConfig;
import com.suncode.plugin.datasource.rest.component.auth.domain.OAuthConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.enums.OAuthConfigFieldKeys;
import com.suncode.plugin.datasource.rest.component.auth.service.AuthorizationService;
import com.suncode.plugin.datasource.rest.util.serializer.OAuthConfigSerializer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang3.StringUtils;

public class OAuthAuthenticator
implements Authenticator {
    private final AuthorizationService authorizationService;
    private final OAuthConfiguration config;

    public OAuthAuthenticator(AuthorizationService authorizationService, OAuthConfiguration config) {
        this.authorizationService = authorizationService;
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Request authenticate(Route route, Response response) throws IOException {
        OkHttpClient client = new OkHttpClient();
        Request.Builder authRequestBuilder = new Request.Builder();
        authRequestBuilder.url(this.config.getAccessTokenUrl());
        FormBody.Builder formBodyBuilder = new FormBody.Builder(StandardCharsets.UTF_8);
        formBodyBuilder.addEncoded(OAuthConfigFieldKeys.GRANT_TYPE.toString(), this.config.getGrantType());
        formBodyBuilder.addEncoded(OAuthConfigFieldKeys.SCOPE.toString(), this.config.getScope());
        if (StringUtils.isNotBlank((CharSequence)this.config.getResource())) {
            formBodyBuilder.addEncoded(OAuthConfigFieldKeys.RESOURCE.toString(), this.config.getResource());
        }
        switch (OAuthConfigFieldKeys.valueOf(this.config.getGrantType().toUpperCase())) {
            case CLIENT_CREDENTIALS: {
                String credentials;
                if (this.config.getClientAuthentication().equals(OAuthConfigFieldKeys.SEND_AS_BASIC.toString())) {
                    credentials = Credentials.basic((String)this.config.getClientId(), (String)this.config.getClientSecret());
                    authRequestBuilder.header(OAuthConfigFieldKeys.AUTHORIZATION_HEADER_NAME.toString(), credentials);
                    break;
                }
                formBodyBuilder.addEncoded(OAuthConfigFieldKeys.CLIENT_ID.toString(), this.config.getClientId());
                formBodyBuilder.addEncoded(OAuthConfigFieldKeys.CLIENT_SECRET.toString(), this.config.getClientSecret());
                break;
            }
            case PASSWORD_CREDENTIALS: {
                String credentials;
                if (this.config.getClientAuthentication().equals(OAuthConfigFieldKeys.SEND_AS_BASIC.toString())) {
                    credentials = Credentials.basic((String)this.config.getClientId(), (String)this.config.getClientSecret());
                    authRequestBuilder.header(OAuthConfigFieldKeys.AUTHORIZATION_HEADER_NAME.toString(), credentials);
                    formBodyBuilder.addEncoded(OAuthConfigFieldKeys.USERNAME.toString(), this.config.getUsername());
                    formBodyBuilder.addEncoded(OAuthConfigFieldKeys.PASSWORD.toString(), this.config.getPassword());
                    break;
                }
                formBodyBuilder.addEncoded(OAuthConfigFieldKeys.CLIENT_ID.toString(), this.config.getClientId());
                formBodyBuilder.addEncoded(OAuthConfigFieldKeys.CLIENT_SECRET.toString(), this.config.getClientSecret());
                formBodyBuilder.addEncoded(OAuthConfigFieldKeys.USERNAME.toString(), this.config.getUsername());
                formBodyBuilder.addEncoded(OAuthConfigFieldKeys.PASSWORD.toString(), this.config.getPassword());
                break;
            }
        }
        Request request = authRequestBuilder.method("POST", (RequestBody)formBodyBuilder.build()).build();
        try (Response res = client.newCall(request).execute();){
            if (res.isSuccessful()) {
                String responseBodyString = res.body().string();
                Map responseBody = (Map)new Gson().fromJson(responseBodyString, new TypeToken<Map<String, String>>(){}.getType());
                String accessToken = (String)responseBody.get(OAuthConfigFieldKeys.ACCESS_TOKEN.toString());
                this.config.setToken(accessToken);
                GsonBuilder gsonBuilder = new GsonBuilder();
                gsonBuilder.registerTypeAdapter(OAuthConfig.class, (Object)new OAuthConfigSerializer());
                this.authorizationService.updateAuthorization(this.config);
                if (this.config.getAddTo().equalsIgnoreCase(OAuthConfigFieldKeys.REQUEST_HEADER.toString())) {
                    Request request2 = response.request().newBuilder().header(OAuthConfigFieldKeys.AUTHORIZATION_HEADER_NAME.toString(), "Bearer " + (String)responseBody.get(OAuthConfigFieldKeys.ACCESS_TOKEN.toString())).build();
                    return request2;
                }
                HttpUrl url = response.request().url().newBuilder().setQueryParameter(OAuthConfigFieldKeys.ACCESS_TOKEN.toString(), this.config.getToken()).build();
                Request request3 = response.request().newBuilder().url(url).build();
                return request3;
            }
            Request request4 = null;
            return request4;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

