/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.auth.authenticator;

import com.suncode.plugin.datasource.rest.component.auth.domain.NTLMAuthConfiguration;
import com.suncode.plugin.datasource.rest.util.authentication.NTLMEngineImpl;
import java.util.List;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMEngineException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTLMAuthenticator
implements Authenticator {
    private static final Logger log = LoggerFactory.getLogger(NTLMAuthenticator.class);
    private static final String NTLM_AUTH_HEADER_KEY = "NTLM";
    private static final String AUTH_HEADER = "Authorization";
    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private final NTLMEngine ntlmEngine = new NTLMEngineImpl();
    private final String username;
    private final String password;
    private final String domain;
    private final String workstation;
    private String ntlmType1Message;

    public NTLMAuthenticator(NTLMAuthConfiguration configuration) {
        this.username = configuration.getUsername();
        this.password = configuration.getPassword();
        this.domain = configuration.getDomain();
        this.workstation = configuration.getWorkstation();
        this.ntlmType1Message = null;
        try {
            this.ntlmType1Message = this.ntlmEngine.generateType1Msg(this.domain, this.workstation);
        }
        catch (NTLMEngineException e) {
            log.error("Error creating NTLM Type 1 message: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Request authenticate(@Nullable Route route, @NotNull Response response) {
        boolean ntlmAuthenticationRequired = false;
        String ntlmChallenge = null;
        NTLMAuthenticator nTLMAuthenticator = this;
        synchronized (nTLMAuthenticator) {
            List authentications = response.headers().values(WWW_AUTHENTICATE_HEADER);
            for (String auth : authentications) {
                if (auth.equalsIgnoreCase(NTLM_AUTH_HEADER_KEY)) {
                    ntlmAuthenticationRequired = true;
                }
                if (!auth.startsWith("NTLM ")) continue;
                ntlmChallenge = auth.substring(NTLM_AUTH_HEADER_KEY.length() + 1);
            }
            if (ntlmChallenge != null) {
                String ntlmType3Message = null;
                try {
                    ntlmType3Message = this.ntlmEngine.generateType3Msg(this.username, this.password, this.domain, this.workstation, ntlmChallenge);
                }
                catch (NTLMEngineException e) {
                    log.error("Error creating NTLM Type 3 message: {}", (Object)e.getMessage());
                }
                return response.request().newBuilder().header(AUTH_HEADER, "NTLM " + ntlmType3Message).build();
            }
            if (ntlmAuthenticationRequired) {
                return response.request().newBuilder().header(AUTH_HEADER, "NTLM " + this.ntlmType1Message).build();
            }
        }
        return null;
    }
}

