/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.archive.services;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.datasource.rest.component.archive.services.ArchiveService;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArchiveServiceImpl
implements ArchiveService {
    private static final Logger log = LoggerFactory.getLogger(ArchiveServiceImpl.class);
    private static final String ADMINISTRATOR_DEFAULT_USERNAME = "admin";
    @Autowired
    private FileService fileService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentClassActionService documentClassActionService;
    @Autowired
    private DocumentClassIndexFinder documentClassIndexFinder;

    @Override
    public void executeClassActions(WfDocument wfDocument) {
        this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
    }

    @Override
    public WfDocument addNewDocumentVersion(byte[] document, long fileId, String documentClassName, String filename, String description, Map<Long, Object> indices, String processId, String activityId) throws Exception {
        DocumentDefinition documentDefinition = this.createDocumentDefinition(documentClassName, filename, description, true, document, indices, processId, activityId);
        String currentDocState = this.fileService.getVersionForFile(Long.valueOf(fileId)).getState();
        if (currentDocState.equals(WfFileVersion.State.STATE_EDIT.toString())) {
            this.fileService.cancelCheckOut(Long.valueOf(fileId));
        }
        this.fileService.checkOut(Long.valueOf(fileId), ADMINISTRATOR_DEFAULT_USERNAME);
        long newestDocumentVersionId = this.fileService.checkIn(documentDefinition, Long.valueOf(fileId), "");
        return this.documentService.getDocument(Long.valueOf(newestDocumentVersionId));
    }

    @Override
    public List<DocumentClassIndex> getClassIndices(String documentClass) {
        Long documentClassId = this.getDocumentClassId(documentClass);
        return this.documentClassIndexFinder.findByDocumentClass(documentClassId);
    }

    @Override
    public WfDocument addNewDocumentToArchive(byte[] document, String documentClassName, String filename, String description, Map<Long, Object> indices, String processId, String activityId, boolean saveAsNewVersion) {
        DocumentDefinition documentDefinition = this.createDocumentDefinition(documentClassName, filename, description, saveAsNewVersion, document, indices, processId, activityId);
        return this.documentService.addDocument(documentDefinition);
    }

    private Long getDocumentClassId(String documentClassName) {
        return Objects.requireNonNull(this.documentClassService.getDocumentClass(documentClassName, new String[0]).getId(), "Document class does not exist: " + documentClassName);
    }

    private DocumentDefinition createDocumentDefinition(String documentClassName, String filename, String description, boolean saveAsNewVersion, byte[] bytes, Map<Long, Object> indices, String processId, String activityId) {
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setDocumentClassId(this.getDocumentClassId(documentClassName));
        documentDefinition.setFileName(filename);
        documentDefinition.setUserName(ADMINISTRATOR_DEFAULT_USERNAME);
        documentDefinition.setInputStream((InputStream)new ByteArrayInputStream(bytes));
        documentDefinition.setSaveAsNewVersion(saveAsNewVersion);
        if (!indices.isEmpty()) {
            documentDefinition.setIndexes(indices);
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            documentDefinition.setDescription(description);
        }
        if (StringUtils.isNotBlank((CharSequence)processId)) {
            documentDefinition.setProcessId(processId);
        }
        if (StringUtils.isNotBlank((CharSequence)activityId)) {
            documentDefinition.setActivityId(activityId);
        }
        return documentDefinition;
    }
}

