/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.json.JsonSmartJsonProvider;
import com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.suncode.plugin.datasource.rest.component.archive.enums.NewVersionOption;
import com.suncode.plugin.datasource.rest.component.archive.services.ArchiveService;
import com.suncode.plugin.datasource.rest.component.auth.authenticator.CookieAuthenticator;
import com.suncode.plugin.datasource.rest.component.auth.authenticator.NTLMAuthenticator;
import com.suncode.plugin.datasource.rest.component.auth.authenticator.OAuthAuthenticator;
import com.suncode.plugin.datasource.rest.component.auth.domain.ApiKeyConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.domain.AuthorizationConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.domain.BasicAuthConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.domain.BearerTokenConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.domain.CookieConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.domain.NTLMAuthConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.domain.OAuthConfiguration;
import com.suncode.plugin.datasource.rest.component.auth.enums.TokenSource;
import com.suncode.plugin.datasource.rest.component.auth.service.AuthorizationService;
import com.suncode.plugin.datasource.rest.component.enums.ParamType;
import com.suncode.plugin.datasource.rest.component.enums.ResponseContentType;
import com.suncode.plugin.datasource.rest.component.interceptor.ApiKeyInterceptor;
import com.suncode.plugin.datasource.rest.component.interceptor.BasicAuthInterceptor;
import com.suncode.plugin.datasource.rest.component.interceptor.BearerTokenInterceptor;
import com.suncode.plugin.datasource.rest.component.parsers.RequestParametersParser;
import com.suncode.plugin.datasource.rest.util.RestDatasourceSpringContext;
import com.suncode.plugin.datasource.rest.util.UrlSanitizer;
import com.suncode.plugin.datasource.rest.util.extractor.ObjectExtractor;
import com.suncode.plugin.datasource.rest.util.interceptors.SetContentTypeInterceptor;
import com.suncode.plugin.datasource.rest.util.logger.DataLogger;
import com.suncode.plugin.datasource.rest.util.parameters.ClassIndexParameter;
import com.suncode.plugin.datasource.rest.util.parameters.ParametersBuilder;
import com.suncode.plugin.datasource.rest.util.parameters.QueryParameter;
import com.suncode.plugin.datasource.rest.util.parameters.QueryResultColumn;
import com.suncode.plugin.datasource.rest.util.parameters.UploadFile;
import com.suncode.plugin.datasource.rest.util.transformer.ResultsTransformer;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.datasource.AbstractDataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceOperation;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.minidev.json.parser.JSONParser;
import okhttp3.Authenticator;
import okhttp3.Cookie;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RestQueryDataSource
extends AbstractDataSourceInstance {
    private static final Logger log = LoggerFactory.getLogger(RestQueryDataSource.class);
    private static final String EMPTY_STRING = "";
    private static final String RAW_DATA_PARAM = "rawdata";
    private static final Gson GSON = new GsonBuilder().create();
    private final AuthorizationConfiguration authorizationConfiguration;
    private final Map<String, String> headers;
    private final String httpMethod;
    private final String url;
    private final String contentType;
    private final List<QueryResultColumn> rawQueryResultColumns;
    private final String schema;
    private final String splitCharacter;
    private final List<QueryParameter> queryParameters;
    private final AuthorizationService authorizationService;
    private final String responseContentType;
    private final int connectionTimeout;
    private final String documentClass;
    private final List<ClassIndexParameter> indexParameters;
    private final String processId;
    private final String activityId;
    private final String filename;
    private final String description;
    private final String fileId;
    private final boolean executeDocumentAction;
    private final String saveAsNewVersion;
    private final ArchiveService archiveService;
    private final Map<String, String> uploadFilesMap;
    private final boolean allowUntrustedCertificates;
    private final boolean isLoggingActive;
    private final String statusCodeRegex;
    private final DataSourceService dataSourceService = RestDatasourceSpringContext.getBean(DataSourceService.class);
    private List<QueryResultColumn> queryResultColumns;
    private OkHttpClient.Builder httpClient;
    private HttpUrl.Builder urlBuilder;

    public RestQueryDataSource(AuthorizationService authorizationService, Parameters parameters) {
        this.archiveService = RestDatasourceSpringContext.getBean(ArchiveService.class);
        this.saveAsNewVersion = (String)parameters.get("saveAsNewVersion", String.class);
        this.executeDocumentAction = parameters.get("executeDocumentAction", Boolean.class) != null && (Boolean)parameters.get("executeDocumentAction", Boolean.class) != false;
        this.filename = (String)parameters.get("filename", String.class);
        this.description = (String)parameters.get("fileDescription", String.class);
        this.fileId = (String)parameters.get("fileId", String.class);
        this.documentClass = (String)parameters.get("documentClass", String.class);
        this.indexParameters = ParametersBuilder.buildIndexParametersList((String[])parameters.get("documentIndex", String[].class), (String[])parameters.get("documentIndexValue", String[].class));
        this.processId = (String)parameters.get("processId", String.class);
        this.activityId = (String)parameters.get("activityId", String.class);
        this.connectionTimeout = (Integer)parameters.get("connectionTimeout", Integer.class);
        this.authorizationService = authorizationService;
        this.authorizationConfiguration = StringUtils.isNotBlank((CharSequence)((CharSequence)parameters.get("authorization"))) ? authorizationService.getAuthorization((String)parameters.get("authorization")) : null;
        this.headers = ParametersBuilder.buildHeadersMap((String[])parameters.get("customHeadersKeys", String[].class), (String[])parameters.get("customHeadersValues", String[].class));
        this.httpMethod = (String)parameters.get("httpMethod");
        this.url = (String)parameters.get("url");
        this.contentType = (String)parameters.get("contentType");
        this.queryParameters = ParametersBuilder.buildQueryParametersList((String[])parameters.get("queryParametersId", String[].class), (String[])parameters.get("queryParametersName", String[].class), (String[])parameters.get("queryParametersType", String[].class), (String[])parameters.get("queryParametersArrayElement", String[].class));
        this.rawQueryResultColumns = ParametersBuilder.buildResultColumnsList((String[])parameters.get("queryResultColumnsId", String[].class), (String[])parameters.get("queryResultColumnsName", String[].class), (String[])parameters.get("queryResultColumnsPath", String[].class), (String[])parameters.get("queryResultColumnsType", String[].class), (String[])parameters.get("queryResultColumnsChildNodeName", String[].class));
        this.schema = (String)parameters.get("schema", String.class);
        this.splitCharacter = (String)parameters.get("splitCharacter", String.class);
        this.responseContentType = (String)parameters.get("responseContentType", String.class);
        this.uploadFilesMap = ParametersBuilder.buildUploadFilesMap((String[])parameters.get("uploadFileKey", String[].class), (String[])parameters.get("uploadFileId", String[].class));
        this.allowUntrustedCertificates = (Boolean)Optional.ofNullable(parameters.get("allowUntrustedCertificates", Boolean.class)).orElse((Boolean)parameters.getRaw("allowUntrustedCertificates").getParameter().getDefaultValue());
        this.isLoggingActive = (Boolean)Optional.ofNullable(parameters.get("isLoggingActive", Boolean.class)).orElse((Boolean)parameters.getRaw("isLoggingActive").getParameter().getDefaultValue());
        this.statusCodeRegex = (String)Optional.ofNullable(parameters.get("statusCodeRegex", String.class)).orElse((String)parameters.getRaw("statusCodeRegex").getParameter().getDefaultValue());
        this.queryResultColumns = RestQueryDataSource.copyQueryResultColumns(this.rawQueryResultColumns);
        this.setJsonPathConfiguration();
    }

    private static List<QueryResultColumn> copyQueryResultColumns(List<QueryResultColumn> list) {
        return list.stream().map(QueryResultColumn::new).collect(Collectors.toList());
    }

    public static List<Cookie> getResponseCookies(HttpUrl url, Headers headers) {
        List cookieStrings = headers.values("Set-Cookie");
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (String cookieString : cookieStrings) {
            Cookie cookie = Cookie.parse((HttpUrl)url, (String)cookieString);
            if (cookie == null) continue;
            cookies.add(cookie);
        }
        return cookies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CountedResult<Map<String, Object>> execute(Map<String, String> parameters, Map<String, String> filters, Pagination pagination) {
        this.httpClient = new OkHttpClient().newBuilder().connectTimeout((long)this.connectionTimeout, TimeUnit.SECONDS).readTimeout((long)this.connectionTimeout, TimeUnit.SECONDS);
        if (this.allowUntrustedCertificates) {
            this.addSslSocketFactory();
            this.setHostnameVerifier();
        }
        String parsedUrl = RequestParametersParser.replaceInputParameter(this.url, ParamType.URL_PARAM, this.queryParameters, parameters, nonModified -> nonModified);
        String encodedUrl = RequestParametersParser.replaceInputParameter(parsedUrl, ParamType.URL_PARAM_ENCODED, this.queryParameters, parameters, UrlSanitizer::sanitize);
        this.urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)encodedUrl)).newBuilder();
        this.queryResultColumns = RestQueryDataSource.copyQueryResultColumns(this.rawQueryResultColumns);
        this.queryResultColumns.forEach(column -> column.setPath(RequestParametersParser.replaceInputParameter(column.getPath(), ParamType.PATH_KEY_PARAM, this.queryParameters, parameters, nonModified -> nonModified)));
        if (this.authorizationConfiguration != null) {
            this.applyAuthorization(parameters);
        }
        Map<String, String> parsedUploadFilesMap = this.uploadFilesMap.entrySet().stream().collect(Collectors.toMap(entry -> RequestParametersParser.replaceInputParameter((String)entry.getKey(), ParamType.FILE_PARAM, this.queryParameters, parameters, nonModified -> nonModified), entry -> RequestParametersParser.replaceInputParameter((String)entry.getValue(), ParamType.FILE_PARAM, this.queryParameters, parameters, nonModified -> nonModified)));
        List<UploadFile> filesToUpload = ParametersBuilder.buildUploadFilesList(parsedUploadFilesMap);
        Request request = this.buildRequest(parameters, filesToUpload);
        if (this.isLoggingActive) {
            DataLogger.log(log, "REQUEST", request.toString());
        }
        SetContentTypeInterceptor setContentTypeInterceptor = new SetContentTypeInterceptor(this.headers.get("Content-Type"));
        try (Response response = this.httpClient.addInterceptor((Interceptor)setContentTypeInterceptor).build().newCall(request).execute();){
            CountedResult<Map<String, Object>> countedResult = this.handleResponse(response, pagination, filters, parameters);
            return countedResult;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void applyAuthorization(Map<String, String> parameters) {
        switch (this.authorizationConfiguration.getAuthorizationType()) {
            case API_KEY: {
                ApiKeyConfiguration apiKeyConfig = (ApiKeyConfiguration)GSON.fromJson(GSON.toJson((Object)this.authorizationConfiguration), ApiKeyConfiguration.class);
                RequestParametersParser.parseAuthorizationParams(apiKeyConfig, this.queryParameters, parameters);
                this.httpClient.addInterceptor((Interceptor)new ApiKeyInterceptor(apiKeyConfig));
                break;
            }
            case BASIC_AUTH: {
                BasicAuthConfiguration basicAuthConfig = (BasicAuthConfiguration)GSON.fromJson(GSON.toJson((Object)this.authorizationConfiguration), BasicAuthConfiguration.class);
                RequestParametersParser.parseAuthorizationParams(basicAuthConfig, this.queryParameters, parameters);
                this.httpClient.addInterceptor((Interceptor)new BasicAuthInterceptor(basicAuthConfig));
                break;
            }
            case BEARER_TOKEN: {
                BearerTokenConfiguration bearerTokenConfig = (BearerTokenConfiguration)GSON.fromJson(GSON.toJson((Object)this.authorizationConfiguration), BearerTokenConfiguration.class);
                if (bearerTokenConfig.getTokenSource() != null && bearerTokenConfig.getTokenSource().equals((Object)TokenSource.DATASOURCE)) {
                    String datasourceId = bearerTokenConfig.getDatasourceId();
                    DataSourceInstance datasource = this.dataSourceService.getDataSource(datasourceId);
                    if (datasource == null) {
                        throw new RuntimeException("Datasource does not exist");
                    }
                    Map<String, String> datasourceParams = this.parseDatasourceParams(bearerTokenConfig.getDatasourceParameters());
                    CountedResult datasourceResult = datasource.execute(datasourceParams, null);
                    String token = ((Map.Entry)((Map)datasourceResult.getData().stream().findFirst().orElseThrow(() -> new RuntimeException("Token datasource did not return any data"))).entrySet().stream().findFirst().orElseThrow(() -> new RuntimeException("Token datasource did not return any data"))).getValue().toString();
                    bearerTokenConfig.setToken(token);
                }
                RequestParametersParser.parseAuthorizationParams(bearerTokenConfig, this.queryParameters, parameters);
                this.httpClient.addInterceptor((Interceptor)new BearerTokenInterceptor(bearerTokenConfig));
                break;
            }
            case COOKIE: {
                CookieConfiguration cookieConfig = (CookieConfiguration)GSON.fromJson(GSON.toJson((Object)this.authorizationConfiguration), CookieConfiguration.class);
                RequestParametersParser.parseAuthorizationParams(cookieConfig, this.queryParameters, parameters);
                this.headers.put("Cookie", cookieConfig.getHeader());
                this.httpClient.authenticator((Authenticator)new CookieAuthenticator(this.authorizationService, cookieConfig));
                break;
            }
            case OAUTH2: {
                OAuthConfiguration oauthConfig = (OAuthConfiguration)GSON.fromJson(GSON.toJson((Object)this.authorizationConfiguration), OAuthConfiguration.class);
                RequestParametersParser.parseAuthorizationParams(oauthConfig, this.queryParameters, parameters);
                if (oauthConfig.getAddTo().equalsIgnoreCase("request_header")) {
                    this.headers.put("Authorization", "Bearer ".concat(oauthConfig.getToken()));
                } else {
                    this.urlBuilder.setQueryParameter("access_token", oauthConfig.getToken());
                }
                this.httpClient.authenticator((Authenticator)new OAuthAuthenticator(this.authorizationService, oauthConfig));
                break;
            }
            case NTLM: {
                NTLMAuthConfiguration ntlmConfig = (NTLMAuthConfiguration)GSON.fromJson(GSON.toJson((Object)this.authorizationConfiguration), NTLMAuthConfiguration.class);
                RequestParametersParser.parseAuthorizationParams(ntlmConfig, this.queryParameters, parameters);
                this.httpClient.authenticator((Authenticator)new NTLMAuthenticator(ntlmConfig));
            }
        }
    }

    private Map<String, String> parseDatasourceParams(String datasourceParameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(datasourceParameters, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String[] keyValue = token.split("=");
            map.put(StringUtils.trim((String)keyValue[0]), StringUtils.trim((String)keyValue[1]));
        }
        return map;
    }

    private Request buildRequest(Map<String, String> parameters, List<UploadFile> filesToUpload) {
        return new Request.Builder().method(this.httpMethod.toUpperCase(), !this.httpMethod.equalsIgnoreCase("GET") ? RequestParametersParser.parseBodyParams(this.queryParameters, parameters, this.contentType, this.schema, this.splitCharacter, filesToUpload) : null).url(this.urlBuilder.build()).headers(Headers.of(RequestParametersParser.parseHeaderParams(this.headers, this.queryParameters, parameters))).build();
    }

    private Map<Long, Object> buildIndicesMap(String documentClass, Map<String, String> parameters, Map<String, Object> outputParameters) {
        List<DocumentClassIndex> classIndices = this.archiveService.getClassIndices(documentClass);
        HashMap<Long, Object> indicesMap = new HashMap<Long, Object>();
        for (ClassIndexParameter indexParam : this.indexParameters) {
            String parsedIndexName = RequestParametersParser.replaceInputParameter(indexParam.getIndexName(), ParamType.FILE_PARAM, this.queryParameters, parameters, nonModified -> nonModified);
            Optional<DocumentClassIndex> classIndex = classIndices.stream().filter(index -> index.getName().equals(parsedIndexName)).findFirst();
            if (!classIndex.isPresent()) {
                log.info("Skipping incorrect index: {}", (Object)parsedIndexName);
                continue;
            }
            if (indexParam.getIndexValue().contains("{") && indexParam.getIndexValue().contains("}")) {
                String key = indexParam.getIndexValue().replace("{", EMPTY_STRING).replace("}", EMPTY_STRING);
                indicesMap.put(classIndex.get().getId(), classIndex.get().getType().parse((String)outputParameters.get(key)));
                continue;
            }
            indicesMap.put(classIndex.get().getId(), classIndex.get().getType().parse(indexParam.getIndexValue()));
        }
        return indicesMap;
    }

    private CountedResult<Map<String, Object>> handleResponse(Response response, Pagination pagination, Map<String, String> filters, Map<String, String> parameters) throws Exception {
        this.checkStatusCode(response.code());
        Headers responseHeaders = response.headers();
        List<Cookie> responseCookies = RestQueryDataSource.getResponseCookies(HttpUrl.get((String)response.request().url().toString()), responseHeaders);
        ResponseBody responseBody = response.body();
        HashMap<String, Object> filledResultColumns = new HashMap<String, Object>();
        if (this.isLoggingActive) {
            DataLogger.log(log, "COOKIES", responseCookies.toString());
            DataLogger.log(log, "HEADERS", responseHeaders.toString());
        }
        if (this.getOperation() == DataSourceOperation.READ) {
            Optional<DataSourceParameter> previewParameter;
            String responseBodyString = responseBody.string();
            if (this.isLoggingActive) {
                DataLogger.log(log, "RESPONSE", responseBodyString);
            }
            if ((previewParameter = this.getOutputParameters().stream().filter(param -> param.getId().equals(RAW_DATA_PARAM)).findFirst()).isPresent()) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("request", RequestParametersParser.getJsonString(this.queryParameters, parameters, this.schema, this.splitCharacter));
                result.put("response", responseBodyString);
                result.put("headers", GSON.toJson((Object)response.headers()));
                List<Map<String, Object>> results = this.buildResultsList(this.calculateMaxColumnLength(result), result, pagination, filters);
                return new CountedResult((long)results.size(), results);
            }
            filledResultColumns.putAll(this.applyDataToResultColumns(responseBodyString, responseHeaders, responseCookies));
        } else if (this.getOperation() == DataSourceOperation.FILE) {
            WfDocument wfDocument;
            byte[] file = IOUtils.toByteArray((InputStream)responseBody.byteStream());
            NewVersionOption newVersionOption = NewVersionOption.valueOf(this.saveAsNewVersion.toUpperCase(Locale.ROOT));
            String parsedDocumentClass = RequestParametersParser.replaceInputParameter(this.documentClass, ParamType.FILE_PARAM, this.queryParameters, parameters, nonModified -> nonModified);
            String parsedFileId = RequestParametersParser.replaceInputParameter(this.fileId, ParamType.FILE_PARAM, this.queryParameters, parameters, nonModified -> nonModified);
            String parsedFilename = RequestParametersParser.replaceInputParameter(this.filename, ParamType.FILE_PARAM, this.queryParameters, parameters, nonModified -> nonModified);
            String parsedDescription = RequestParametersParser.replaceInputParameter(this.description, ParamType.FILE_PARAM, this.queryParameters, parameters, nonModified -> nonModified);
            String parsedProcessId = RequestParametersParser.replaceInputParameter(this.processId, ParamType.FILE_PARAM, this.queryParameters, parameters, nonModified -> nonModified);
            String parsedActivityId = RequestParametersParser.replaceInputParameter(this.activityId, ParamType.FILE_PARAM, this.queryParameters, parameters, nonModified -> nonModified);
            filledResultColumns.putAll(this.applyDataToResultColumns(responseHeaders, responseCookies));
            Map<Long, Object> parsedIndices = this.buildIndicesMap(parsedDocumentClass, parameters, filledResultColumns);
            if (newVersionOption.equals((Object)NewVersionOption.FILEID) && StringUtils.isNotBlank((CharSequence)parsedFileId)) {
                wfDocument = this.archiveService.addNewDocumentVersion(file, Long.parseLong(parsedFileId), parsedDocumentClass, parsedFilename, parsedDescription, parsedIndices, parsedProcessId, parsedActivityId);
            } else {
                boolean newVersion = newVersionOption.equals((Object)NewVersionOption.INDICES);
                wfDocument = this.archiveService.addNewDocumentToArchive(file, parsedDocumentClass, parsedFilename, parsedDescription, parsedIndices, parsedProcessId, parsedActivityId, newVersion);
            }
            if (this.executeDocumentAction) {
                this.archiveService.executeClassActions(wfDocument);
            }
        }
        if (this.queryResultColumns.isEmpty()) {
            return new CountedResult(0L, new ArrayList());
        }
        int dataMaxLength = this.calculateMaxColumnLength(filledResultColumns);
        List<Map<String, Object>> results = this.buildResultsList(dataMaxLength, filledResultColumns, pagination, filters);
        return new CountedResult((long)results.size(), pagination == null ? results : ResultsTransformer.applyPagination(results, pagination));
    }

    private void checkStatusCode(int statusCode) {
        if (StringUtils.isBlank((CharSequence)this.statusCodeRegex)) {
            return;
        }
        if (!String.valueOf(statusCode).matches(this.statusCodeRegex)) {
            throw new RuntimeException("Restricted response code");
        }
    }

    private Map<String, Object> applyDataToResultColumns(Headers responseHeaders, List<Cookie> responseCookies) {
        LinkedHashMap<String, Object> resultData = new LinkedHashMap<String, Object>();
        this.addResponseHeaderResult(responseHeaders, resultData);
        this.addResponseCookieResult(responseCookies, resultData);
        return resultData;
    }

    private Map<String, Object> applyDataToResultColumns(String responseBody, Headers responseHeaders, List<Cookie> responseCookies) throws ParserConfigurationException, IOException, SAXException {
        LinkedHashMap<String, Object> resultData = new LinkedHashMap<String, Object>();
        this.addResponseBodyResult(responseBody, resultData);
        this.addResponseHeaderResult(responseHeaders, resultData);
        this.addResponseCookieResult(responseCookies, resultData);
        return resultData;
    }

    private void addResponseCookieResult(List<Cookie> responseCookies, Map<String, Object> resultData) {
        resultData.putAll(this.queryResultColumns.stream().filter(queryResultColumn -> ParamType.COOKIE_PARAM.getValue().equals(queryResultColumn.getType())).collect(Collectors.toMap(QueryResultColumn::getId, queryResultColumn -> this.getCookiesValues(responseCookies, queryResultColumn.getPath()), (existing, replacement) -> existing, LinkedHashMap::new)));
    }

    private void addResponseHeaderResult(Headers responseHeaders, Map<String, Object> resultData) {
        resultData.putAll(this.queryResultColumns.stream().filter(queryResultColumn -> ParamType.HEADER_PARAM.getValue().equals(queryResultColumn.getType())).collect(Collectors.toMap(QueryResultColumn::getId, queryResultColumn -> this.getHeaderValues(responseHeaders, queryResultColumn.getPath()), (existing, replacement) -> existing, LinkedHashMap::new)));
    }

    private void addResponseBodyResult(String responseBody, Map<String, Object> resultData) throws ParserConfigurationException, IOException, SAXException {
        if (StringUtils.isBlank((CharSequence)responseBody)) {
            this.queryResultColumns.stream().filter(queryResultColumn -> ParamType.BODY_PARAM.getValue().equals(queryResultColumn.getType())).forEach(queryResultColumn -> resultData.put(queryResultColumn.getId(), EMPTY_STRING));
        } else if (this.responseContentType.equals(ResponseContentType.XML.getValue())) {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(responseBody)));
            resultData.putAll(this.queryResultColumns.stream().filter(queryResultColumn -> ParamType.BODY_PARAM.getValue().equals(queryResultColumn.getType())).collect(Collectors.toMap(QueryResultColumn::getId, queryResultColumn -> this.getParameterValue(doc, (QueryResultColumn)queryResultColumn), (existing, replacement) -> existing, LinkedHashMap::new)));
        } else {
            DocumentContext documentContext = JsonPath.parse((String)responseBody);
            resultData.putAll(this.queryResultColumns.stream().filter(queryResultColumn -> ParamType.BODY_PARAM.getValue().equals(queryResultColumn.getType())).collect(Collectors.toMap(QueryResultColumn::getId, queryResultColumn -> this.getParameterValue(documentContext, (QueryResultColumn)queryResultColumn), (existing, replacement) -> existing, LinkedHashMap::new)));
        }
    }

    private Object getCookiesValues(List<Cookie> responseCookies, String cookieKey) {
        return responseCookies.stream().filter(cookie -> cookieKey.equals("*") || cookie.name().equals(cookieKey)).map(cookie -> cookieKey.equals("*") ? cookie.name() + "=" + cookie.value() : cookie.value()).collect(Collectors.joining(";"));
    }

    private Object getHeaderValues(Headers responseHeaders, String headerKey) {
        StringBuilder stringBuilder = new StringBuilder();
        responseHeaders.forEach(pair -> {
            if (((String)pair.getFirst()).equals(headerKey)) {
                stringBuilder.append((String)pair.getSecond()).append("\n\r");
            }
        });
        return stringBuilder.toString().replaceFirst("[\n\r]+$", EMPTY_STRING);
    }

    private Object getParameterValue(DocumentContext documentContext, QueryResultColumn parameter) {
        try {
            String path;
            JsonPath jsonPath;
            Object object = StringUtils.isBlank((CharSequence)parameter.getChildNodeName()) ? documentContext.read(parameter.getPath(), new Predicate[0]) : ((jsonPath = JsonPath.compile((String)(path = parameter.getPath() + "." + parameter.getChildNodeName()), (Predicate[])new Predicate[0])).isDefinite() ? documentContext.read(path, new Predicate[0]) : ((List)documentContext.read(parameter.getPath(), new Predicate[0])).stream().map(jsonObject -> jsonObject.getOrDefault(parameter.getChildNodeName(), EMPTY_STRING)).collect(Collectors.toList()));
            return object != null ? object : EMPTY_STRING;
        }
        catch (Exception e) {
            return EMPTY_STRING;
        }
    }

    private List<String> getParameterValue(Document document, QueryResultColumn parameter) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.compile(parameter.getPath()).evaluate(document, XPathConstants.NODESET);
            return IntStream.range(0, nodeList.getLength()).mapToObj(nodeNo -> {
                String childValue = StringUtils.isBlank((CharSequence)parameter.getChildNodeName()) ? nodeList.item(nodeNo).getTextContent() : this.getChildValue(nodeList.item(nodeNo), parameter.getChildNodeName());
                return childValue.replace(";", ":");
            }).collect(Collectors.toList());
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private String getChildValue(Node item, String childName) {
        NodeList childNodes = item.getChildNodes();
        String childValue = EMPTY_STRING;
        for (int childNo = 0; childNo < childNodes.getLength(); ++childNo) {
            if (!childNodes.item(childNo).getNodeName().equals(childName)) continue;
            childValue = childNodes.item(childNo).getTextContent();
        }
        return childValue;
    }

    private int calculateMaxColumnLength(Map<String, Object> data) {
        return data.values().stream().map(obj -> obj instanceof List ? ((List)obj).size() : -1).max(Comparator.comparing(Integer::valueOf)).orElseThrow(() -> new RuntimeException("Cannot calculate maximum length of data!"));
    }

    private List<Map<String, Object>> buildResultsList(int dataMaxLength, Map<String, Object> data, Pagination pagination, Map<String, String> filters) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (dataMaxLength >= 0) {
            IntStream.range(0, dataMaxLength).forEach(i -> {
                Map rowsMap = this.queryResultColumns.stream().collect(Collectors.toMap(QueryResultColumn::getId, queryResultColumn -> ObjectExtractor.extract(data.get(queryResultColumn.getId()), i), (existing, replacement) -> existing, LinkedHashMap::new));
                results.add(rowsMap);
            });
        } else {
            results.add(data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString())));
        }
        if (filters != null) {
            ResultsTransformer.applyFilters(results, filters);
        }
        if (pagination != null) {
            ResultsTransformer.applySort(results, pagination.getSorter());
        }
        return results;
    }

    public Set<DataSourceParameter> getInputParameters() {
        return this.queryParameters.stream().map(queryParameter -> new DataSourceParameter(queryParameter.getId(), queryParameter.getName())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<DataSourceParameter> getOutputParameters() {
        return this.queryResultColumns.stream().map(queryResultColumn -> new DataSourceParameter(queryResultColumn.getId(), queryResultColumn.getName())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void setHostnameVerifier() {
        this.httpClient.hostnameVerifier((hostname, session) -> true);
    }

    private void addSslSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        this.httpClient.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustAllCerts[0]);
    }

    private void setJsonPathConfiguration() {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final MappingProvider mappingProvider = new JsonSmartMappingProvider();
            private final int flags = JSONParser.DEFAULT_PERMISSIVE_MODE & 0xFFFFEFFF;
            private final JsonProvider jsonProvider = new JsonSmartJsonProvider(this.flags);

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }
}

