/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.rest.component.interceptor;

import com.suncode.plugin.datasource.rest.component.auth.domain.ApiKeyConfiguration;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ApiKeyInterceptor
implements Interceptor {
    private final ApiKeyConfiguration config;

    public ApiKeyInterceptor(ApiKeyConfiguration config) {
        this.config = config;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.config.getAddTo().equals("header")) {
            request = request.newBuilder().header(this.config.getKey(), this.config.getValue()).build();
            return chain.proceed(request);
        }
        HttpUrl url = request.url().newBuilder().setQueryParameter(this.config.getKey(), this.config.getValue()).build();
        request = request.newBuilder().url(url).build();
        return chain.proceed(request);
    }
}

