/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.utils.loggers;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class ResultFileLogger {
    static final String SUCCESS_MSG = "Processed files: ";
    static final String FAILURE_MSG = "Not processed files: ";
    List<String> success = new LinkedList<String>();
    List<String> failure = new LinkedList<String>();
    Logger log;

    public ResultFileLogger(Logger logger) {
        this.log = logger;
    }

    public void addSuccess(String record) {
        this.success.add(record);
    }

    public void addFailure(String record) {
        this.failure.add(record);
    }

    public void logResults() {
        this.printResult(this.success, SUCCESS_MSG);
        this.printResult(this.failure, FAILURE_MSG);
    }

    private void printResult(List<String> result, String message) {
        String resultString = "";
        if (!result.isEmpty()) {
            resultString = String.join((CharSequence)", ", result);
        }
        this.log.info(message + "[" + resultString + "]");
    }

    public String getSuccessResult() {
        return this.getLoggerClassName() + ": Processed files: [" + String.join((CharSequence)", ", this.success) + "]";
    }

    public String getFailureResult() {
        return this.getLoggerClassName() + ": Not processed files: [" + String.join((CharSequence)", ", this.failure) + "]";
    }

    public void logTaskResults(org.apache.log4j.Logger taskLog) {
        taskLog.info((Object)this.getFailureResult());
        taskLog.info((Object)this.getSuccessResult());
    }

    private String getLoggerClassName() {
        String className = this.log.getName();
        return className.substring(className.lastIndexOf(".") + 1);
    }
}

