/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.utils.files;

import com.suncode.plugin.utils.paths.PluginDirectory;
import java.io.File;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryFileFinder {
    private static final Logger log = LoggerFactory.getLogger(DirectoryFileFinder.class);

    public static Collection<File> getFilesWithExtension(PluginDirectory pluginDirectory) {
        return DirectoryFileFinder.getFilesWithExtensionFromPath(pluginDirectory.getPath(), pluginDirectory.getExtension(), null);
    }

    public static Collection<File> getFilesWithExtension(PluginDirectory pluginDirectory, String subFolder) {
        return DirectoryFileFinder.getFilesWithExtensionFromPath(pluginDirectory.getPath(), pluginDirectory.getExtension(), subFolder);
    }

    public static Collection<File> getFilesWithExtensionFromPath(String pathToConfig, String extension) {
        return DirectoryFileFinder.getFilesWithExtensionFromPath(pathToConfig, extension, null);
    }

    public static Collection<File> getFilesWithExtensionFromPath(String pathToConfig, String extension, String subFolder) {
        if (StringUtils.isNotBlank((CharSequence)pathToConfig)) {
            if (subFolder != null) {
                pathToConfig = (String)pathToConfig + "/" + subFolder;
            }
            File folder = new File((String)pathToConfig);
            try {
                return FileUtils.listFiles((File)folder, (String[])extension.split(","), (!StringUtils.isNotBlank((CharSequence)subFolder) ? 1 : 0) != 0);
            }
            catch (UncheckedIOException ioException) {
                log.info("Folder not found: " + folder.getPath());
            }
        } else {
            log.info("Specified path is empty");
        }
        return Collections.emptyList();
    }
}

