/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.services.translation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.utils.loggers.ResultFileLogger;
import com.suncode.pwfl.configuration.dto.translations.TranslationType;
import com.suncode.pwfl.translation.ImportConfigElementTranslationsService;
import com.suncode.pwfl.translation.ImportCustomTranslationsService;
import com.suncode.pwfl.translation.ImportSystemTranslationsService;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitTranslationImportService {
    private static final Logger log = LoggerFactory.getLogger(InitTranslationImportService.class);
    ResultFileLogger fileLogger = new ResultFileLogger(log);
    @Autowired
    ImportConfigElementTranslationsService configElementTranslationsService;
    @Autowired
    ImportSystemTranslationsService systemTranslationsService;
    @Autowired
    ImportCustomTranslationsService customTranslationsService;
    private final ObjectMapper mapper = new ObjectMapper();

    public void importTranslations(Collection<File> files, TranslationType translationType) {
        this.importTranslations(files, translationType, null);
    }

    public void importTranslations(Collection<File> files, TranslationType translationType, org.apache.log4j.Logger taskLog) {
        files.forEach(file -> {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                JsonNode translalations = this.mapper.readTree((Reader)reader);
                switch (translationType) {
                    case SYSTEM: {
                        this.systemTranslationsService.importTranslationsFromJson(translalations);
                        break;
                    }
                    case CONFIG_ELEMENT: {
                        this.configElementTranslationsService.importTranslationsFromJson(translalations);
                        break;
                    }
                    case CUSTOM: {
                        this.customTranslationsService.importTranslationsFromJson(translalations);
                    }
                }
                this.fileLogger.addSuccess(file.getName());
            }
            catch (Throwable e) {
                log.error(e.toString());
                e.printStackTrace();
                this.fileLogger.addFailure(file.getName());
            }
        });
        this.fileLogger.logResults();
        if (taskLog != null) {
            this.fileLogger.logTaskResults(taskLog);
        }
    }
}

