/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.services.sysparam;

import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.plugin.components.QaUtilsContext;
import com.suncode.plugin.services.sysparam.dto.SystemParamDto;
import com.suncode.plugin.utils.loggers.ResultFileLogger;
import com.suncode.plugin.utils.serializer.Deserializer;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import java.io.BufferedReader;
import java.io.File;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitSystemParamService {
    private static final Logger log = LoggerFactory.getLogger(InitSystemParamService.class);
    ResultFileLogger fileLogger = new ResultFileLogger(log);
    @Autowired
    SystemParameterService systemParameterService;

    public void initSystemPrams(Collection<File> files) {
        this.initSystemPrams(files, null);
    }

    public void initSystemPrams(Collection<File> files, org.apache.log4j.Logger taskLog) {
        DatabaseType currentDbType = QaUtilsContext.getDatabaseType();
        files.forEach(file -> {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                List<SystemParamDto> newParams = Deserializer.getList(reader, SystemParamDto.class);
                newParams.stream().filter(param -> param.getDbTypeList().contains(currentDbType)).forEach(param -> {
                    SystemParameter systemParameter = this.systemParameterService.getParameter(param.getParamKey());
                    if (systemParameter == null) {
                        log.info("System parameter with key of " + param.getParamKey() + " does not exist.");
                    } else {
                        this.systemParameterService.updateValue(param.getNewValue(), systemParameter);
                    }
                });
                this.fileLogger.addSuccess(file.getName());
            }
            catch (Throwable e) {
                log.error(e.toString());
                e.printStackTrace();
                this.fileLogger.addFailure(file.getName());
            }
        });
        this.fileLogger.logResults();
        if (taskLog != null) {
            this.fileLogger.logTaskResults(taskLog);
        }
    }
}

