/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.services.structure;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.suncode.plugin.services.structure.RuntimeTypeAdapterFactory;
import com.suncode.plugin.utils.loggers.ResultFileLogger;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.configuration.ConfigurationImportService;
import com.suncode.pwfl.configuration.dto.ConfigurationDtoRoot;
import com.suncode.pwfl.configuration.dto.plugins.PluginConfigurationDtoRoot;
import com.suncode.pwfl.configuration.plugins.PluginConfigurationService;
import com.suncode.pwfl.plugin.modules.configurationTransfer.PluginConfigurationTransferDefinition;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitStructureService {
    private static final Logger log = LoggerFactory.getLogger(InitStructureService.class);
    ResultFileLogger fileLogger = new ResultFileLogger(log);
    @Autowired
    ConfigurationImportService configurationImportService;
    @Autowired
    private PluginConfigurationService pluginConfigurationService;

    public void importStructure(Collection<File> files) {
        this.importStructure(files, null);
    }

    public void importStructure(Collection<File> files, org.apache.log4j.Logger taskLog) {
        UserContext.activate((String)"admin");
        Gson gson = this.prepareGsonForPlugins();
        files.forEach(file -> {
            try {
                String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                ConfigurationDtoRoot configDto = (ConfigurationDtoRoot)gson.fromJson(content, ConfigurationDtoRoot.class);
                this.configurationImportService.importConfiguration(configDto, "enhydra", "default", false);
                this.fileLogger.addSuccess(file.getName());
            }
            catch (Throwable e) {
                log.error(e.toString());
                e.printStackTrace();
                this.fileLogger.addFailure(file.getName());
            }
        });
        this.fileLogger.logResults();
        if (taskLog != null) {
            this.fileLogger.logTaskResults(taskLog);
        }
    }

    private Gson prepareGsonForPlugins() {
        RuntimeTypeAdapterFactory<PluginConfigurationDtoRoot> pluginDtoAdapterFactory = RuntimeTypeAdapterFactory.of(PluginConfigurationDtoRoot.class, "pluginId");
        List pluginConfigDefinitions = this.pluginConfigurationService.getAllPluginTransferDefinitions();
        for (PluginConfigurationTransferDefinition pluginConfigDef : pluginConfigDefinitions) {
            if (pluginConfigDef.getConfigurationDtoRootClass() == null) continue;
            Class clazz = pluginConfigDef.getConfigurationDtoRootClass();
            pluginDtoAdapterFactory.registerSubtype(clazz, pluginConfigDef.getPluginId());
        }
        pluginDtoAdapterFactory.registerSubtype(PluginConfigurationDtoRoot.class, "com.suncode.noplugin-default");
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping().registerTypeAdapterFactory(pluginDtoAdapterFactory);
        return gsonBuilder.create();
    }
}

