/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.services.schema.util;

import com.suncode.dbexplorer.alias.Table;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.Record;
import com.suncode.dbexplorer.database.schema.ColumnSchema;
import com.suncode.dbexplorer.database.schema.TableSchema;
import com.suncode.dbexplorer.database.type.BasicDataType;
import com.suncode.dbexplorer.database.type.DataType;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelRecordsResolver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Record> readRecords(InputStream inputStream, Database database, DatabaseType databaseType, Table table) throws IOException {
        OPCPackage opcPackage;
        try {
            opcPackage = OPCPackage.open((InputStream)inputStream);
        }
        catch (InvalidFormatException e1) {
            throw new IOException(e1);
        }
        try {
            ArrayList<Record> records = new ArrayList<Record>();
            XSSFWorkbook workbook = new XSSFWorkbook(opcPackage);
            XSSFFormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFRow headerRow = sheet.getRow(0);
            String[] columnNames = new String[headerRow.getLastCellNum()];
            for (Cell cell : headerRow) {
                columnNames[cell.getColumnIndex()] = cell.getStringCellValue();
            }
            for (Row row : sheet) {
                if (row.getRowNum() == 0 || this.isRowEmpty(row)) continue;
                TableSchema tableSchema = table.getTableSchema();
                Record record = new Record(tableSchema.getSchema(), tableSchema.getName(), database);
                for (int i = 0; i < columnNames.length; ++i) {
                    String columnName = this.resolveColumnName(databaseType, columnNames[i]);
                    if (columnName == null || !table.getTableSchema().hasColumn(columnName)) continue;
                    Cell cell = row.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                    ColumnSchema columnSchema = table.getTableSchema().getColumn(columnName);
                    BasicDataType basicType = BasicDataType.of((DataType)columnSchema.getType());
                    evaluator.evaluateInCell(cell);
                    Object value = this.readCellValue(cell, basicType, databaseType);
                    record.set(columnName, value);
                }
                records.add(record);
            }
            ArrayList<Record> arrayList = records;
            return arrayList;
        }
        finally {
            opcPackage.close();
        }
    }

    private Object readCellValue(Cell cell, BasicDataType basicType, DatabaseType databaseType) {
        Object value = null;
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                if (basicType == BasicDataType.DATE || basicType == BasicDataType.DATETIME || basicType == BasicDataType.TIME) {
                    value = cell.getDateCellValue();
                    break;
                }
                value = cell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                if (!databaseType.equals((Object)DatabaseType.ORACLE)) break;
                value = (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        }
        return value;
    }

    private boolean isRowEmpty(Row row) {
        for (Cell cell : row) {
            if (cell.toString().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private String resolveColumnName(DatabaseType databaseType, String columnName) {
        if (databaseType.equals((Object)DatabaseType.ORACLE)) {
            return columnName.toUpperCase();
        }
        if (databaseType.equals((Object)DatabaseType.POSTGRES)) {
            return columnName.toLowerCase();
        }
        return columnName;
    }
}

