/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.services.process;

import com.suncode.plugin.services.process.dto.ActivityToChangeDto;
import com.suncode.plugin.services.process.dto.InitProcessDto;
import com.suncode.plugin.utils.loggers.ResultFileLogger;
import com.suncode.plugin.utils.serializer.Deserializer;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleFinder;
import com.suncode.pwfl.administration.substitution.SubstitutionService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.util.QueryExecutor;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.activity.DelegatedActivity;
import com.suncode.pwfl.workflow.activity.exception.ActivityAlreadyCompletedException;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.assignment.AssignmentService;
import com.suncode.pwfl.workflow.assignment.TransferType;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.util.CreateProcessResult;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import java.io.BufferedReader;
import java.io.File;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitProcessesService {
    private static final Logger log = LoggerFactory.getLogger(InitProcessesService.class);
    ResultFileLogger fileLogger = new ResultFileLogger(log);
    @Autowired
    ProcessService processService;
    @Autowired
    AssignmentService assignmentService;
    @Autowired
    RoleFinder roleFinder;
    @Autowired
    ActivityService activityService;
    @Autowired
    SubstitutionService substitutionService;
    @Autowired
    QueryExecutor queryExecutor;

    public void importProcesses(Collection<File> files) {
        this.importProcesses(files, null);
    }

    public void importProcesses(Collection<File> files, org.apache.log4j.Logger taskLog) {
        files.forEach(file -> {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                List<InitProcessDto> processesToImport = Deserializer.getList(reader, InitProcessDto.class);
                this.createProcesses(processesToImport);
                this.fileLogger.addSuccess(file.getName());
            }
            catch (Throwable e) {
                log.error(e.toString());
                e.printStackTrace();
                this.fileLogger.addFailure(file.getName());
            }
        });
        this.fileLogger.logResults();
        if (taskLog != null) {
            this.fileLogger.logTaskResults(taskLog);
        }
    }

    private void createProcesses(List<InitProcessDto> processesToImport) {
        for (InitProcessDto createProcessData : processesToImport) {
            ProcessBuilderDefinition definition = new ProcessBuilderDefinition();
            definition.setPackageId(createProcessData.getPackageId());
            definition.setProcessDefId(createProcessData.getProcessDefId());
            definition.setCreator("admin");
            Map<String, Object> variables = createProcessData.getVariables();
            if (variables != null) {
                definition.setVariables(variables);
            }
            for (int i = 0; i < createProcessData.getNumberOfProcesses(); ++i) {
                CreateProcessResult processResult = this.processService.createProcessWithResult(definition);
                this.handleAssignments(definition, processResult, createProcessData.getAssignToUsers());
                this.handleActivitiesToChange(processResult.getProcessId(), createProcessData.getActivitiesToChange());
            }
        }
    }

    private void handleAssignments(ProcessBuilderDefinition definition, CreateProcessResult processResult, List<String> newUsers) {
        if (newUsers == null || newUsers.isEmpty()) {
            return;
        }
        Activity activity = this.activityService.getActivity(processResult.getProcessId(), processResult.getActivityId(), new String[0]);
        Role role = this.roleFinder.findByActivity(definition.getPackageId(), definition.getProcessDefId(), activity.getActivityDefinitionId());
        newUsers.forEach(newUserLogin -> {
            try {
                this.assignmentService.assignActivityToUser(processResult.getProcessId(), processResult.getActivityId(), newUserLogin);
                log.info("Zadanie zosta\u0142o przypisane do u\u017cytkownika: [{}]", newUserLogin);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List substituteUsers = this.substitutionService.getSubstituteUsersForProcessType(newUserLogin, definition.getProcessDefId(), role);
            for (User substitute : substituteUsers) {
                String substituteUser = substitute.getUserName();
                if (newUsers.contains(substituteUser)) continue;
                try {
                    this.assignmentService.assignActivityToUser(processResult.getProcessId(), processResult.getActivityId(), substituteUser);
                }
                catch (Exception e) {
                    log.error("B\u0142\u0105d podczas przypisywania zadania " + processResult.getActivityId() + " do u\u017cytkownika " + substituteUser, (Object)e.getMessage());
                }
                this.queryExecutor.save((Object)new DelegatedActivity(processResult.getActivityId(), newUserLogin, substituteUser, TransferType.SUBSTITUTION));
                log.info("Zadanie zosta\u0142o przypisane r\u00f3wnie\u017c do zast\u0119pcy u\u017cytkownika: [{}]", (Object)substituteUser);
            }
        });
    }

    private void handleActivitiesToChange(String processId, List<ActivityToChangeDto> activitiesToChange) {
        if (activitiesToChange == null || activitiesToChange.isEmpty()) {
            return;
        }
        List openActivities = this.activityService.getOpenActivitiesForProcess(processId);
        activitiesToChange.forEach(activityToChangeDto -> openActivities.stream().filter(activity -> activity.getActivityDefinitionId().contains(activityToChangeDto.getActivityDefId())).forEach(activity -> this.changeActivity(activity.getProcessId(), activity.getActivityId(), (ActivityToChangeDto)activityToChangeDto)));
    }

    private void changeActivity(String processId, String activityId, ActivityToChangeDto activityToChangeDto) {
        switch (activityToChangeDto.getActivityOperation()) {
            case ACCEPT: {
                AcceptationDefinition acceptationDefinition = new AcceptationDefinition(processId, activityId, activityToChangeDto.getExecutor(), activityToChangeDto.getActionName(), null, true);
                try {
                    this.activityService.acceptActivity(acceptationDefinition);
                }
                catch (Exception e) {
                    log.error("Can not accept activity", (Throwable)e);
                }
                break;
            }
            case ABORT: {
                this.activityService.abort(processId, activityId);
                break;
            }
            case SUSPEND: {
                try {
                    this.activityService.suspendActivity(activityId, processId);
                }
                catch (ActivityAlreadyCompletedException e) {
                    e.printStackTrace();
                }
                break;
            }
            case TERMINATE: {
                this.activityService.changeStateIfPossible(processId, activityId, ActivityState.TERMINATED);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)activityToChangeDto.getActivityOperation()));
            }
        }
    }
}

