/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.services.pluginconf;

import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.services.pluginconf.dto.RefreshPluginConfigDto;
import com.suncode.plugin.utils.loggers.ResultFileLogger;
import com.suncode.plugin.utils.serializer.Deserializer;
import java.io.BufferedReader;
import java.io.File;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitRefreshPluginConfig {
    private static final Logger log = LoggerFactory.getLogger(InitRefreshPluginConfig.class);
    ResultFileLogger fileLogger = new ResultFileLogger(log);
    @Autowired
    ConfigurationFileService configurationFileService;

    public void refreshPluginConfig(Collection<File> files) {
        this.refreshPluginConfig(files, null);
    }

    public void refreshPluginConfig(Collection<File> files, org.apache.log4j.Logger taskLog) {
        files.forEach(file -> {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                List<RefreshPluginConfigDto> configs = Deserializer.getList(reader, RefreshPluginConfigDto.class);
                if (configs != null) {
                    configs.forEach(config -> this.configurationFileService.refreshConfiguration(config.getPluginId()));
                }
                this.fileLogger.addSuccess(file.getName());
            }
            catch (Throwable e) {
                log.error(e.toString());
                e.printStackTrace();
                this.fileLogger.addFailure(file.getName());
            }
        });
        this.fileLogger.logResults();
        if (taskLog != null) {
            this.fileLogger.logTaskResults(taskLog);
        }
    }
}

