/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.services.maps;

import com.suncode.plugin.pwe.service.xpdl.XpdlZipService;
import com.suncode.plugin.pwe.web.support.dto.xpdl.ExportZipDto;
import com.suncode.plugin.utils.loggers.ResultFileLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitXpdlMapsService {
    private static final Logger log = LoggerFactory.getLogger(InitXpdlMapsService.class);
    @Autowired
    private XpdlZipService xpdlZipService;
    ResultFileLogger fileLogger = new ResultFileLogger(log);

    public void importXpdlFromZip(Collection<File> files) {
        this.importXpdlFromZip(files, null);
    }

    public void importXpdlFromZip(Collection<File> files, org.apache.log4j.Logger taskLog) {
        files.forEach(file -> {
            try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                String fileName = file.getName();
                ExportZipDto exportZipDto = this.xpdlZipService.export(inputStream, fileName);
                if (exportZipDto.getSuccess().booleanValue()) {
                    this.fileLogger.addSuccess(fileName);
                } else {
                    this.fileLogger.addFailure(fileName);
                }
            }
            catch (IOException e) {
                log.error(e.toString());
                e.printStackTrace();
            }
        });
        this.fileLogger.logResults();
        if (taskLog != null) {
            this.fileLogger.logTaskResults(taskLog);
        }
    }
}

