/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.services.document;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.services.document.dto.BasicDocumentDto;
import com.suncode.plugin.services.document.dto.DocumentClassDto;
import com.suncode.plugin.utils.loggers.ResultFileLogger;
import com.suncode.plugin.utils.paths.PluginDirectory;
import com.suncode.plugin.utils.serializer.Deserializer;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Service;

@Service
public class InitDocumentsService {
    private static final Logger log = LoggerFactory.getLogger(InitDocumentsService.class);
    ResultFileLogger fileLogger = new ResultFileLogger(log);
    @Autowired
    DocumentService documentService;
    @Autowired
    DocumentClassService documentClassService;
    @Autowired
    DocumentClassActionService documentClassActionService;

    public Map<String, DocumentClassDto> getAllDocumentsClass() {
        List documentClassSet = this.documentClassService.getAll(new String[]{"indexes"});
        return documentClassSet.stream().collect(Collectors.toMap(DocumentClass::getName, DocumentClassDto::new));
    }

    public void importDocuments(Collection<File> files) {
        this.importDocuments(files, null);
    }

    public void importDocuments(Collection<File> files, org.apache.log4j.Logger taskLog) {
        Map<String, DocumentClassDto> documentClassCache = this.getAllDocumentsClass();
        files.forEach(file -> {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                List<BasicDocumentDto> documentsToImport = Deserializer.getList(reader, BasicDocumentDto.class);
                this.addDocuments(documentsToImport, documentClassCache);
                this.fileLogger.addSuccess(file.getName());
            }
            catch (Throwable e) {
                log.error(e.toString());
                e.printStackTrace();
                this.fileLogger.addFailure(file.getName());
            }
        });
        this.fileLogger.logResults();
        if (taskLog != null) {
            this.fileLogger.logTaskResults(taskLog);
        }
    }

    private void addDocuments(List<BasicDocumentDto> basicDocumentDtos, Map<String, DocumentClassDto> documentClassCache) {
        basicDocumentDtos.forEach(basicDocDto -> {
            DocumentDefinition dd = new DocumentDefinition();
            DocumentClassDto cachedDocClass = (DocumentClassDto)documentClassCache.get(basicDocDto.getDocumentClass());
            if (cachedDocClass != null) {
                ClassPathResource fileResource;
                dd.setDocumentClassId(cachedDocClass.getDocClassId());
                dd.setFileName(basicDocDto.getFileName());
                dd.setUserName(basicDocDto.getUserName());
                dd.setDescription(basicDocDto.getDescription());
                dd.setSaveAsNewVersion(basicDocDto.isSaveAsNewVersion());
                HashMap indexes = new HashMap();
                basicDocDto.getIndexes().forEach((idx, value) -> {
                    Long indexIdx = cachedDocClass.getIndexMap().get(idx);
                    if (indexIdx != null) {
                        indexes.put(indexIdx, value);
                    }
                });
                dd.setIndexes(indexes);
                if (StringUtils.isNotBlank((CharSequence)basicDocDto.getCustomFilePath())) {
                    String fullPath = Paths.get(PluginDirectory.DOCUMENTS.getPath(), new String[0]).resolve(basicDocDto.getCustomFilePath()).toString();
                    if (!Files.exists(Paths.get(fullPath, new String[0]), new LinkOption[0])) {
                        log.error("Custom file does not exist: {}", (Object)fullPath);
                        return;
                    }
                    fileResource = new FileSystemResource(fullPath);
                } else {
                    fileResource = basicDocDto.getFileType().getResource();
                }
                int counter = basicDocDto.getNumberOfDocs();
                for (int i = 0; i < counter; ++i) {
                    try (InputStream targetStream = fileResource.getInputStream();){
                        dd.setInputStream(targetStream);
                        WfDocument wfDocument = this.documentService.addDocument(dd);
                        this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }
}

