/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.services.datasource;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.suncode.plugin.utils.loggers.ResultFileLogger;
import com.suncode.pwfl.component.exception.InvalidComponentException;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.datasource.dao.DataSourceDeclaration;
import com.suncode.pwfl.datasource.declaration.DataSourceDeserializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitDataSourceService {
    private static final Logger log = LoggerFactory.getLogger(InitDataSourceService.class);
    ResultFileLogger fileLogger = new ResultFileLogger(log);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final TypeReference<List<DataSourceDeclaration>> DATASOURCE_DECLARATIONS = new TypeReference<List<DataSourceDeclaration>>(){};
    @Autowired
    DataSourceService dataSourceService;

    public InitDataSourceService() {
        SimpleModule dataSourceModule = new SimpleModule();
        dataSourceModule.addDeserializer(DataSourceDeclaration.class, (JsonDeserializer)new DataSourceDeserializer());
        this.objectMapper.registerModule((Module)dataSourceModule);
    }

    public void importDatasource(Collection<File> files) {
        this.importDatasource(files, null);
    }

    public void importDatasource(Collection<File> files, org.apache.log4j.Logger taskLog) {
        files.forEach(file -> {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                String json = IOUtils.toString((Reader)reader);
                this.addDatasource(json);
                this.fileLogger.addSuccess(file.getName());
            }
            catch (Throwable e) {
                log.error(e.toString());
                e.printStackTrace();
                this.fileLogger.addFailure(file.getName());
            }
        });
        this.fileLogger.logResults();
        if (taskLog != null) {
            this.fileLogger.logTaskResults(taskLog);
        }
    }

    private void addDatasource(String json) {
        List<DataSourceDeclaration> declarations = this.readDataSources(json);
        declarations.forEach(declaration -> {
            if (!this.dataSourceExists(declaration.getId())) {
                this.dataSourceService.addDeclaration(declaration);
            }
        });
    }

    private List<DataSourceDeclaration> readDataSources(String jsonDeclarations) {
        try {
            return (List)this.objectMapper.readValue(jsonDeclarations, DATASOURCE_DECLARATIONS);
        }
        catch (Exception e) {
            throw new InvalidComponentException("Invalid DataSources declarations.", (Throwable)e);
        }
    }

    private boolean dataSourceExists(String id) {
        return this.dataSourceService.getDeclaration(id) != null;
    }
}

