/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.services.datasource;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.datasource.rest.component.auth.dto.AuthorizationConfigurationDto;
import com.suncode.plugin.datasource.rest.component.auth.service.AuthorizationService;
import com.suncode.plugin.utils.loggers.ResultFileLogger;
import com.suncode.pwfl.component.exception.InvalidComponentException;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitAuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(InitAuthorizationService.class);
    ResultFileLogger fileLogger = new ResultFileLogger(log);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final TypeReference<List<AuthorizationConfigurationDto>> AUTHORIZATION_DECLARATIONS = new TypeReference<List<AuthorizationConfigurationDto>>(){};
    @Autowired
    AuthorizationService authorizationService;

    public void importAuthorization(Collection<File> files) {
        this.importAuthorization(files, null);
    }

    public void importAuthorization(Collection<File> files, org.apache.log4j.Logger taskLog) {
        files.forEach(file -> {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                String json = IOUtils.toString((Reader)reader);
                this.addAuthorization(json);
                this.fileLogger.addSuccess(file.getName());
            }
            catch (Throwable e) {
                log.error(e.toString());
                e.printStackTrace();
                this.fileLogger.addFailure(file.getName());
            }
        });
        this.fileLogger.logResults();
        if (taskLog != null) {
            this.fileLogger.logTaskResults(taskLog);
        }
    }

    private void addAuthorization(String json) {
        List<AuthorizationConfigurationDto> declarations = this.readAuthorization(json);
        declarations.forEach(declaration -> {
            if (!this.isAuthorizationExists(declaration.getId())) {
                try {
                    this.authorizationService.saveAuthorization(declaration);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private List<AuthorizationConfigurationDto> readAuthorization(String jsonDeclarations) {
        try {
            return (List)this.objectMapper.readValue(jsonDeclarations, AUTHORIZATION_DECLARATIONS);
        }
        catch (Exception e) {
            throw new InvalidComponentException("Invalid Authorization declarations.", (Throwable)e);
        }
    }

    private boolean isAuthorizationExists(String id) {
        return this.authorizationService.getAuthorization(id) != null;
    }
}

