/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.services.datasource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.suncode.plugin.datasource.rest.component.auth.config.ApiKeyConfig;
import com.suncode.plugin.datasource.rest.component.auth.config.BasicAuthConfig;
import com.suncode.plugin.datasource.rest.component.auth.config.BearerTokenConfig;
import com.suncode.plugin.datasource.rest.component.auth.config.CookieConfig;
import com.suncode.plugin.datasource.rest.component.auth.config.NTLMAuthConfig;
import com.suncode.plugin.datasource.rest.component.auth.config.OAuthConfig;
import com.suncode.plugin.datasource.rest.component.auth.dto.AuthorizationConfigurationDto;
import com.suncode.plugin.datasource.rest.component.auth.enums.AuthorizationType;
import com.suncode.plugin.datasource.rest.component.auth.service.AuthorizationService;
import com.suncode.plugin.services.datasource.AuthorizationExportDto;
import com.suncode.plugin.utils.serializer.ApiKeyConfigSerializer;
import com.suncode.plugin.utils.serializer.BasicAuthConfigSerializer;
import com.suncode.plugin.utils.serializer.BearerTokenConfigSerializer;
import com.suncode.plugin.utils.serializer.CookieConfigSerializer;
import com.suncode.plugin.utils.serializer.NTLMAuthConfigSerializer;
import com.suncode.plugin.utils.serializer.OAuthConfigSerializer;
import com.suncode.pwfl.search.CountedResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationExportService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationExportService.class);
    @Autowired
    private AuthorizationService authorizationService;
    private final Gson gson = this.initializeGson();
    private final Gson cleanGson = this.initializePreatyGson();

    private Gson initializePreatyGson() {
        return new GsonBuilder().serializeNulls().setPrettyPrinting().create();
    }

    private Gson initializeGson() {
        return new GsonBuilder().serializeNulls().registerTypeAdapter(ApiKeyConfig.class, (Object)new ApiKeyConfigSerializer()).registerTypeAdapter(BasicAuthConfig.class, (Object)new BasicAuthConfigSerializer()).registerTypeAdapter(BearerTokenConfig.class, (Object)new BearerTokenConfigSerializer()).registerTypeAdapter(CookieConfig.class, (Object)new CookieConfigSerializer()).registerTypeAdapter(NTLMAuthConfig.class, (Object)new NTLMAuthConfigSerializer()).registerTypeAdapter(OAuthConfig.class, (Object)new OAuthConfigSerializer()).create();
    }

    public String exportAuthorizations() {
        CountedResult result = this.authorizationService.getAuthorizations("", null, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        List authorizations = result.getData();
        ArrayList<AuthorizationExportDto> exportData = new ArrayList<AuthorizationExportDto>();
        for (AuthorizationConfigurationDto authDto : authorizations) {
            AuthorizationExportDto exportDto = AuthorizationExportDto.fromAuthorizationDto(authDto);
            String convertedConfig = this.convertAuthorizationConfig(authDto);
            exportDto.setAuthorizationConfig(convertedConfig);
            exportData.add(exportDto);
        }
        return this.cleanGson.toJson(exportData);
    }

    private String convertAuthorizationConfig(AuthorizationConfigurationDto authDto) {
        String originalConfig = authDto.getAuthorizationConfig();
        AuthorizationType authorizationType = authDto.getAuthorizationType();
        try {
            return switch (authorizationType) {
                default -> throw new IncompatibleClassChangeError();
                case AuthorizationType.API_KEY -> this.convertConfig(originalConfig, ApiKeyConfig.class);
                case AuthorizationType.BASIC_AUTH -> this.convertConfig(originalConfig, BasicAuthConfig.class);
                case AuthorizationType.BEARER_TOKEN -> this.convertConfig(originalConfig, BearerTokenConfig.class);
                case AuthorizationType.COOKIE -> this.convertConfig(originalConfig, CookieConfig.class);
                case AuthorizationType.OAUTH2 -> this.convertConfig(originalConfig, OAuthConfig.class);
                case AuthorizationType.NTLM -> this.convertConfig(originalConfig, NTLMAuthConfig.class);
            };
        }
        catch (Exception e) {
            log.error("Error converting authorization config for type: {}", (Object)authorizationType, (Object)e);
            return originalConfig;
        }
    }

    private <T> String convertConfig(String originalConfig, Class<T> configClass) {
        try {
            Object config = this.gson.fromJson(originalConfig, configClass);
            return this.gson.toJson(config);
        }
        catch (Exception e) {
            log.error("Error converting {} config", (Object)configClass.getSimpleName(), (Object)e);
            return originalConfig;
        }
    }
}

