/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.components.scheduledtask;

import com.suncode.plugin.services.datasource.InitAuthorizationService;
import com.suncode.plugin.services.datasource.InitDataSourceService;
import com.suncode.plugin.services.document.InitDocumentsService;
import com.suncode.plugin.services.maps.InitXpdlMapsService;
import com.suncode.plugin.services.pluginconf.InitRefreshPluginConfig;
import com.suncode.plugin.services.process.InitProcessesService;
import com.suncode.plugin.services.structure.InitStructureService;
import com.suncode.plugin.services.sysparam.InitSystemParamService;
import com.suncode.plugin.services.translation.InitTranslationImportService;
import com.suncode.plugin.utils.files.DirectoryFileFinder;
import com.suncode.plugin.utils.paths.PluginDirectory;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.configuration.dto.translations.TranslationType;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class InitConfigScheduledTask {
    private static final Logger log = LoggerFactory.getLogger(InitConfigScheduledTask.class);
    @Autowired
    InitSystemParamService initSystemParamService;
    @Autowired
    InitDocumentsService initDocumentsService;
    @Autowired
    InitDataSourceService initDataSourceService;
    @Autowired
    InitAuthorizationService initAuthorizationService;
    @Autowired
    InitProcessesService initProcessesService;
    @Autowired
    InitStructureService initStructureService;
    @Autowired
    InitXpdlMapsService initXpdlMapsService;
    @Autowired
    InitTranslationImportService initTranslationImportService;
    @Autowired
    InitRefreshPluginConfig initRefreshPluginConfig;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("init-config-scheduled-task")).name("scheduledtask.init-config.name")).description("scheduledtask.init-config.desc")).cancelable().parameter().id("init-sysparam").name("System parameter files directory").type((Type)Types.STRING).defaultValue((Object)PluginDirectory.SYSPARAM.getPath()).optional().create()).parameter().id("init-maps").name("Xpdl zip files directory").type((Type)Types.STRING).defaultValue((Object)PluginDirectory.MAPS.getPath()).optional().create()).parameter().id("init-structures").name("Structure files directory").type((Type)Types.STRING).defaultValue((Object)PluginDirectory.STRUCTURES.getPath()).optional().create()).parameter().id("init-documents").name("Documents files directory").type((Type)Types.STRING).defaultValue((Object)PluginDirectory.DOCUMENTS.getPath()).optional().create()).parameter().id("init-data-sources").name("DataSource files directory").type((Type)Types.STRING).defaultValue((Object)PluginDirectory.DATASOURCE.getPath()).optional().create()).parameter().id("init-authorization").name("Authorization files directory").type((Type)Types.STRING).defaultValue((Object)PluginDirectory.AUTHORIZATION.getPath()).optional().create()).parameter().id("init-processes").name("Processes files directory").type((Type)Types.STRING).defaultValue((Object)PluginDirectory.PROCESSES.getPath()).optional().create()).parameter().id("init-translations").name("Translation files directory").type((Type)Types.STRING).defaultValue((Object)PluginDirectory.TRANSLATION.getPath()).optional().create()).parameter().id("init-refresh-config").name("Refresh config files directory").type((Type)Types.STRING).defaultValue((Object)PluginDirectory.REFRESHCONFIG.getPath()).optional().create();
    }

    public void execute(@Param(value="init-sysparam") String sysParamPath, @Param(value="init-maps") String mapsPath, @Param(value="init-structures") String structuresPath, @Param(value="init-documents") String documentsPath, @Param(value="init-data-sources") String dataSourcesPath, @Param(value="init-authorization") String authorizationPath, @Param(value="init-processes") String processesPath, @Param(value="init-translations") String translationsPath, @Param(value="init-refresh-config") String refreshConfigPath, org.apache.log4j.Logger taskLog) {
        this.initSystemParamService.initSystemPrams(DirectoryFileFinder.getFilesWithExtensionFromPath(sysParamPath, "json"), taskLog);
        this.initXpdlMapsService.importXpdlFromZip(DirectoryFileFinder.getFilesWithExtensionFromPath(mapsPath, "zip"), taskLog);
        this.initStructureService.importStructure(DirectoryFileFinder.getFilesWithExtensionFromPath(structuresPath, "json"), taskLog);
        this.initDocumentsService.importDocuments(DirectoryFileFinder.getFilesWithExtensionFromPath(documentsPath, "json"), taskLog);
        this.initDataSourceService.importDatasource(DirectoryFileFinder.getFilesWithExtensionFromPath(dataSourcesPath, "json"), taskLog);
        this.initAuthorizationService.importAuthorization(DirectoryFileFinder.getFilesWithExtensionFromPath(authorizationPath, "json"), taskLog);
        this.initProcessesService.importProcesses(DirectoryFileFinder.getFilesWithExtensionFromPath(processesPath, "json"), taskLog);
        this.initTranslationImportService.importTranslations(DirectoryFileFinder.getFilesWithExtensionFromPath(translationsPath, "json", "system"), TranslationType.SYSTEM, taskLog);
        this.initTranslationImportService.importTranslations(DirectoryFileFinder.getFilesWithExtensionFromPath(translationsPath, "json", "custom"), TranslationType.CUSTOM, taskLog);
        this.initTranslationImportService.importTranslations(DirectoryFileFinder.getFilesWithExtensionFromPath(translationsPath, "json", "config"), TranslationType.CONFIG_ELEMENT, taskLog);
        this.initRefreshPluginConfig.refreshPluginConfig(DirectoryFileFinder.getFilesWithExtensionFromPath(refreshConfigPath, "json"), taskLog);
    }
}

