/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.components.hooks;

import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.support.PluginHook;
import com.suncode.plugin.services.translation.InitTranslationImportService;
import com.suncode.plugin.utils.files.DirectoryFileFinder;
import com.suncode.plugin.utils.paths.PluginDirectory;
import com.suncode.pwfl.configuration.dto.translations.TranslationType;
import java.io.File;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitTranslationsHook
implements PluginHook {
    private static final Logger log = LoggerFactory.getLogger(InitTranslationsHook.class);
    @Autowired
    InitTranslationImportService initTranslationImportService;

    public void start() throws PluginsException {
        Collection<File> customTranslations = DirectoryFileFinder.getFilesWithExtension(PluginDirectory.TRANSLATION, "custom");
        this.initTranslationImportService.importTranslations(customTranslations, TranslationType.CUSTOM);
        Collection<File> systemTranslations = DirectoryFileFinder.getFilesWithExtension(PluginDirectory.TRANSLATION, "system");
        this.initTranslationImportService.importTranslations(systemTranslations, TranslationType.SYSTEM);
        Collection<File> configTranslations = DirectoryFileFinder.getFilesWithExtension(PluginDirectory.TRANSLATION, "config");
        this.initTranslationImportService.importTranslations(configTranslations, TranslationType.CONFIG_ELEMENT);
    }

    public void stop() throws PluginsException {
    }
}

