/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.components.hooks;

import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.alias.AliasService;
import com.suncode.dbexplorer.alias.Table;
import com.suncode.dbexplorer.alias.data.CreateTable;
import com.suncode.dbexplorer.database.ConnectionString;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseFactory;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.DatabaseType;
import com.suncode.dbexplorer.database.Record;
import com.suncode.plugin.components.QaUtilsContext;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.support.PluginHook;
import com.suncode.plugin.services.schema.dto.InitTableDto;
import com.suncode.plugin.services.schema.util.ExcelRecordsResolver;
import com.suncode.plugin.utils.files.DirectoryFileFinder;
import com.suncode.plugin.utils.loggers.ResultFileLogger;
import com.suncode.plugin.utils.paths.PluginDirectory;
import com.suncode.plugin.utils.serializer.Deserializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class InitDatabaseSchemaHook
implements PluginHook {
    private static final Logger log = LoggerFactory.getLogger(InitDatabaseSchemaHook.class);
    final String SYSTEM_ALIAS = "PlusWorkflow";
    ResultFileLogger hookLogger = new ResultFileLogger(log);
    @Autowired
    AliasService aliasService;
    @Autowired
    private DatabaseFactory databaseFactory;
    private final ExcelRecordsResolver excelRecordsResolver = new ExcelRecordsResolver();
    private DatabaseType databaseType;
    private Alias alias;
    private Database database;
    private String schemaName;

    private void prepareSchema() {
        this.alias = this.aliasService.getAlias("PlusWorkflow");
        if (this.alias == null) {
            this.alias = this.aliasService.addSystemAlias();
        }
        Assert.notNull((Object)this.aliasService.getAlias("PlusWorkflow"), (String)"System alias not set");
        ConnectionString connectionString = this.alias.getWrappedConnectionString();
        this.database = this.databaseFactory.create(connectionString, true);
        this.schemaName = this.database.getSchema().getName();
        this.databaseType = QaUtilsContext.getDatabaseType();
    }

    public void start() throws PluginsException {
        this.prepareSchema();
        this.initCreateTables();
        this.database.updateSchema();
        this.initImportData();
        this.hookLogger.logResults();
    }

    private void initCreateTables() {
        this.database.withinSession(session -> {
            DirectoryFileFinder.getFilesWithExtension(PluginDirectory.DATABASE).forEach(file -> {
                try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                    List<InitTableDto> tablesToImport = Deserializer.getList(reader, InitTableDto.class).stream().filter(initTableDto -> initTableDto.getDbTypeList().contains(this.databaseType)).collect(Collectors.toList());
                    this.initSchema(session, tablesToImport);
                    this.hookLogger.addSuccess(file.getName());
                }
                catch (Throwable e) {
                    log.error(e.toString());
                    e.printStackTrace();
                    this.hookLogger.addFailure(file.getName());
                }
            });
            return null;
        });
    }

    private void initImportData() {
        DirectoryFileFinder.getFilesWithExtension(PluginDirectory.DATABASE).forEach(file -> this.database.withinSession(session -> {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                List<InitTableDto> tablesToImport = Deserializer.getList(reader, InitTableDto.class).stream().filter(initTableDto -> initTableDto.getDbTypeList().contains(this.databaseType)).collect(Collectors.toList());
                this.importDataSchema(session, tablesToImport);
                this.hookLogger.addSuccess(file.getName());
            }
            catch (Throwable e) {
                log.error(e.toString());
                e.printStackTrace();
                this.hookLogger.addFailure(file.getName());
            }
            return null;
        }));
    }

    private void initSchema(DatabaseSession session, List<InitTableDto> tablesToImport) {
        tablesToImport.forEach(initTableDto -> {
            String tableName = this.resolveTableName(initTableDto.getTableName());
            Table table = this.alias.getTable(this.schemaName, tableName, this.databaseFactory);
            if (table == null && initTableDto.getTableColumns() != null) {
                this.createTable(session, (InitTableDto)initTableDto);
            } else {
                log.warn("Table [" + tableName + "] is already created. Skipped");
            }
        });
    }

    private void importDataSchema(DatabaseSession session, List<InitTableDto> tablesToImport) {
        tablesToImport.forEach(initTableDto -> {
            String tableName = this.resolveTableName(initTableDto.getTableName());
            Table table = this.alias.getTable(this.schemaName, tableName, this.databaseFactory);
            String importDataFileName = initTableDto.getImportDataFile();
            boolean overrideData = initTableDto.isOverrideData();
            if (table != null && importDataFileName != null) {
                this.addRecords(session, table, importDataFileName, overrideData);
            } else {
                log.warn("Insert records: Table [" + tableName + "] not exist or parameter importDataFile is not defined. Skipped");
            }
        });
    }

    private void createTable(DatabaseSession session, InitTableDto initTableDto) {
        Set<CreateTable.Column> columns = this.resolveDatabaseColumns(initTableDto.getTableColumns());
        CreateTable table = new CreateTable(this.schemaName, initTableDto.getTableName(), columns);
        session.createTable(table);
        log.info("Table [" + table.getName() + "] has been created");
    }

    private Set<CreateTable.Column> resolveDatabaseColumns(Set<InitTableDto.InitColumn> columns) {
        HashSet<CreateTable.Column> resolvedColumns = new HashSet<CreateTable.Column>();
        columns.forEach(column -> {
            String columnName = this.databaseType.equals((Object)DatabaseType.ORACLE) ? column.getName().toUpperCase() : column.getName();
            CreateTable.Column resolvedColumn = new CreateTable.Column(columnName, column.getDataType());
            resolvedColumn.setPrimaryKey(column.isPrimaryKey());
            resolvedColumn.setNullable(column.isNullable());
            resolvedColumn.setAutoIncrement(column.isAutoIncrement());
            resolvedColumns.add(resolvedColumn);
        });
        return resolvedColumns;
    }

    private void addRecords(DatabaseSession session, Table table, String importDataFile, boolean overrideData) {
        File exelFile = new File(PluginDirectory.DATABASE.getPath() + FileSystems.getDefault().getSeparator() + importDataFile);
        try (InputStream inputStream = Files.newInputStream(exelFile.toPath(), new OpenOption[0]);){
            List<Record> records = this.excelRecordsResolver.readRecords(inputStream, this.database, this.databaseType, table);
            if (overrideData) {
                session.delete().from(table.getTableSchema().getFullName()).execute();
            }
            records.forEach(record -> {
                try {
                    session.insert(record);
                }
                catch (Exception e) {
                    log.error("Can not insert record with data [" + String.valueOf(record.getData()) + "]");
                    throw e;
                }
            });
            log.info("Data records into table [" + table.getName() + "] have been inserted");
            this.hookLogger.addSuccess(exelFile.getName());
        }
        catch (Throwable e) {
            log.error("An error occurred while inserting data into the table [" + table.getName() + "]. Reason: ", e);
            this.hookLogger.addFailure(exelFile.getName());
        }
    }

    private String resolveTableName(String tableName) {
        switch (this.databaseType) {
            case ORACLE: {
                return tableName.toUpperCase();
            }
            case POSTGRES: {
                return tableName.toLowerCase();
            }
        }
        return tableName;
    }

    public void stop() throws PluginsException {
    }
}

